
<?php $attributes ??= new \Illuminate\View\ComponentAttributeBag;

$__newAttributes = [];
$__propNames = \Illuminate\View\ComponentAttributeBag::extractPropNames((['name', 'value' => '', 'placeholder' => 'Start writing your content...', 'height' => '400px']));

foreach ($attributes->all() as $__key => $__value) {
    if (in_array($__key, $__propNames)) {
        $$__key = $$__key ?? $__value;
    } else {
        $__newAttributes[$__key] = $__value;
    }
}

$attributes = new \Illuminate\View\ComponentAttributeBag($__newAttributes);

unset($__propNames);
unset($__newAttributes);

foreach (array_filter((['name', 'value' => '', 'placeholder' => 'Start writing your content...', 'height' => '400px']), 'is_string', ARRAY_FILTER_USE_KEY) as $__key => $__value) {
    $$__key = $$__key ?? $__value;
}

$__defined_vars = get_defined_vars();

foreach ($attributes->all() as $__key => $__value) {
    if (array_key_exists($__key, $__defined_vars)) unset($$__key);
}

unset($__defined_vars, $__key, $__value); ?>

<div class="rich-editor-wrapper" x-data="{ content: <?php echo \Illuminate\Support\Js::from($value)->toHtml() ?> }">
    
    <div class="flex flex-wrap gap-2 p-3 bg-gray-100 dark:bg-gray-700 border border-gray-300 dark:border-gray-600 rounded-t-lg">
        <button type="button" 
                data-command="bold"
                class="px-3 py-1.5 text-sm font-bold bg-white dark:bg-gray-800 border border-gray-300 dark:border-gray-600 rounded hover:bg-gray-50 dark:hover:bg-gray-700"
                title="Bold">
            <strong>B</strong>
        </button>
        <button type="button" 
                data-command="italic"
                class="px-3 py-1.5 text-sm italic bg-white dark:bg-gray-800 border border-gray-300 dark:border-gray-600 rounded hover:bg-gray-50 dark:hover:bg-gray-700"
                title="Italic">
            <em>I</em>
        </button>
        <div class="w-px h-6 bg-gray-300 dark:bg-gray-600"></div>
        <button type="button" 
                data-command="formatBlock"
                data-value="h1"
                class="px-3 py-1.5 text-sm font-semibold bg-white dark:bg-gray-800 border border-gray-300 dark:border-gray-600 rounded hover:bg-gray-50 dark:hover:bg-gray-700"
                title="Heading 1">
            H1
        </button>
        <button type="button" 
                data-command="formatBlock"
                data-value="h2"
                class="px-3 py-1.5 text-sm font-semibold bg-white dark:bg-gray-800 border border-gray-300 dark:border-gray-600 rounded hover:bg-gray-50 dark:hover:bg-gray-700"
                title="Heading 2">
            H2
        </button>
        <button type="button" 
                data-command="formatBlock"
                data-value="h3"
                class="px-3 py-1.5 text-sm font-semibold bg-white dark:bg-gray-800 border border-gray-300 dark:border-gray-600 rounded hover:bg-gray-50 dark:hover:bg-gray-700"
                title="Heading 3">
            H3
        </button>
        <div class="w-px h-6 bg-gray-300 dark:bg-gray-600"></div>
        <button type="button" 
                data-command="insertUnorderedList"
                class="px-3 py-1.5 text-sm bg-white dark:bg-gray-800 border border-gray-300 dark:border-gray-600 rounded hover:bg-gray-50 dark:hover:bg-gray-700"
                title="Bullet List">
            •
        </button>
        <button type="button" 
                data-command="insertOrderedList"
                class="px-3 py-1.5 text-sm bg-white dark:bg-gray-800 border border-gray-300 dark:border-gray-600 rounded hover:bg-gray-50 dark:hover:bg-gray-700"
                title="Numbered List">
            1.
        </button>
        <button type="button" 
                data-command="formatBlock"
                data-value="blockquote"
                class="px-3 py-1.5 text-sm bg-white dark:bg-gray-800 border border-gray-300 dark:border-gray-600 rounded hover:bg-gray-50 dark:hover:bg-gray-700"
                title="Quote">
            "
        </button>
        <div class="w-px h-6 bg-gray-300 dark:bg-gray-600"></div>
        <button type="button" 
                data-command="link"
                class="px-3 py-1.5 text-sm bg-white dark:bg-gray-800 border border-gray-300 dark:border-gray-600 rounded hover:bg-gray-50 dark:hover:bg-gray-700"
                title="Insert Link">
            🔗
        </button>
        <button type="button" 
                data-command="image"
                class="px-3 py-1.5 text-sm bg-white dark:bg-gray-800 border border-gray-300 dark:border-gray-600 rounded hover:bg-gray-50 dark:hover:bg-gray-700"
                title="Insert Image">
            🖼️
        </button>
    </div>
    
    
    <div class="border-x border-gray-300 dark:border-gray-600">
        <textarea 
            id="<?php echo e($name); ?>_editor" 
            name="<?php echo e($name); ?>"
            class="w-full p-4 bg-white dark:bg-gray-800 text-gray-900 dark:text-white border-0 focus:outline-none focus:ring-0 resize-none"
            style="min-height: <?php echo e($height); ?>; font-family: 'Inter', sans-serif; line-height: 1.75;"
            placeholder="<?php echo e($placeholder); ?>"
            required
        ><?php echo e($value); ?></textarea>
    </div>
    
    <div class="border-b border-x border-gray-300 dark:border-gray-600 rounded-b-lg p-2 bg-gray-50 dark:bg-gray-700">
        <p class="text-xs text-gray-500 dark:text-gray-400">Tip: Use the toolbar above to format your content</p>
    </div>
</div>

<script>
(function() {
    const editorId = '<?php echo e($name); ?>_editor';
    const editor = document.getElementById(editorId);
    if (!editor) return;
    
    // Toolbar button handlers
    const wrapper = editor.closest('.rich-editor-wrapper');
    if (!wrapper) return;
    
    wrapper.querySelectorAll('[data-command]').forEach(btn => {
        btn.addEventListener('click', function(e) {
            e.preventDefault();
            const command = this.dataset.command;
            const value = this.dataset.value;
            
            editor.focus();
            
            if (command === 'link') {
                const url = prompt('Enter URL:');
                if (url) {
                    const text = window.getSelection().toString() || url;
                    document.execCommand('createLink', false, url);
                }
            } else if (command === 'image') {
                // Open media browser
                window.dispatchEvent(new CustomEvent('open-media-browser', { 
                    detail: { editorId, editor } 
                }));
            } else if (value) {
                document.execCommand(command, false, value);
            } else {
                document.execCommand(command, false, null);
            }
        });
    });
})();
</script>


<?php /**PATH C:\xampp\htdocs\linkie-dev\resources\views/components/admin/rich-editor.blade.php ENDPATH**/ ?>