<!DOCTYPE html>
<html lang="<?php echo e(str_replace('_', '-', app()->getLocale())); ?>">
<head>
    <meta charset="utf-8">
    <meta name="viewport" content="width=device-width, initial-scale=1">
    <meta name="csrf-token" content="<?php echo e(csrf_token()); ?>">

    <title><?php echo $__env->yieldContent('title', 'Linkie.dev - Technical Blog & Product Showcase'); ?></title>

    <!-- SEO Meta Tags -->
    <?php echo $__env->yieldContent('meta'); ?>

    <!-- Google Fonts - Inter, Montserrat, Cairo for bold typography -->
    <link rel="preconnect" href="https://fonts.googleapis.com">
    <link rel="preconnect" href="https://fonts.gstatic.com" crossorigin>
    <link href="https://fonts.googleapis.com/css2?family=Inter:wght@400;500;600;700&family=Montserrat:wght@700;800;900&family=Cairo:wght@400;700;900&display=swap" rel="stylesheet">

    <!-- Scripts -->
    <?php echo app('Illuminate\Foundation\Vite')(['resources/css/app.css', 'resources/js/app.js']); ?>
    
    <!-- Alpine.js for interactive components (FAQ accordion, etc.) -->
    <script defer src="https://cdn.jsdelivr.net/npm/alpinejs@3.x.x/dist/cdn.min.js"></script>
</head>
<body class="bg-[#121212] text-[#E0E0E0] font-sans antialiased">
    <!-- Navigation Component -->
    <?php echo $__env->make('components.navbar', array_diff_key(get_defined_vars(), ['__data' => 1, '__path' => 1]))->render(); ?>

    <!-- Main Content -->
    <main>
        <?php echo $__env->yieldContent('content'); ?>
    </main>

    <!-- Footer Component -->
    <?php echo $__env->make('components.footer', array_diff_key(get_defined_vars(), ['__data' => 1, '__path' => 1]))->render(); ?>

    <!-- Flash Messages: Fixed position notification with auto-dismiss --}}
    <?php if(session('success')): ?>
        
        <div class="fixed bottom-4 right-4 bg-[#00B4D8] text-white px-6 py-3 rounded-lg shadow-lg z-50 animate-fade-in">
            <?php echo e(session('success')); ?>

        </div>
    <?php endif; ?>
    <?php if(session('error')): ?>
        
        <div class="fixed bottom-4 right-4 bg-red-600 text-white px-6 py-3 rounded-lg shadow-lg z-50 animate-fade-in">
            <?php echo e(session('error')); ?>

        </div>
    <?php endif; ?>
</body>
</html>

<?php /**PATH C:\xampp\htdocs\linkie-dev\resources\views/layouts/main.blade.php ENDPATH**/ ?>