

<?php $__env->startSection('title', 'Navigation Manager'); ?>

<?php $__env->startSection('page-header'); ?>
<div class="flex items-center justify-between">
    <div>
        <h1 class="text-3xl font-bold text-gray-900 dark:text-white">Navigation Manager</h1>
        <p class="mt-1 text-sm text-gray-500 dark:text-gray-400">Manage your site navigation menu</p>
    </div>
    <button onclick="document.getElementById('menu-form').classList.toggle('hidden')" 
            class="inline-flex items-center px-4 py-2 bg-cyan-600 hover:bg-cyan-700 text-white font-medium rounded-lg transition-colors">
        <svg class="w-5 h-5 mr-2" fill="none" stroke="currentColor" viewBox="0 0 24 24">
            <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M12 4v16m8-8H4" />
        </svg>
        Add Menu Item
    </button>
</div>
<?php $__env->stopSection(); ?>

<?php $__env->startSection('content'); ?>

<div id="menu-form" class="hidden mb-6 bg-white dark:bg-gray-800 rounded-lg shadow-sm border border-gray-200 dark:border-gray-700 p-6">
    <h3 class="text-lg font-semibold text-gray-900 dark:text-white mb-4">Add New Menu Item</h3>
    <form action="<?php echo e(route('admin.navigation.store')); ?>" method="POST" class="space-y-4">
        <?php echo csrf_field(); ?>
        <div class="grid grid-cols-1 md:grid-cols-2 gap-4">
            <div>
                <label class="block text-sm font-medium text-gray-700 dark:text-gray-300 mb-2">Label</label>
                <input type="text" name="label" required class="w-full px-4 py-2 bg-white dark:bg-gray-700 border border-gray-300 dark:border-gray-600 rounded-lg">
            </div>
            <div>
                <label class="block text-sm font-medium text-gray-700 dark:text-gray-300 mb-2">URL or Route</label>
                <input type="text" name="url" placeholder="/page or route:name" class="w-full px-4 py-2 bg-white dark:bg-gray-700 border border-gray-300 dark:border-gray-600 rounded-lg">
            </div>
        </div>
        <div class="flex justify-end space-x-3">
            <button type="button" onclick="document.getElementById('menu-form').classList.add('hidden')" 
                    class="px-4 py-2 bg-gray-600 hover:bg-gray-700 text-white rounded-lg">
                Cancel
            </button>
            <button type="submit" class="px-4 py-2 bg-cyan-600 hover:bg-cyan-700 text-white rounded-lg">
                Add Item
            </button>
        </div>
    </form>
</div>


<div class="bg-white dark:bg-gray-800 rounded-lg shadow-sm border border-gray-200 dark:border-gray-700 p-6">
    <h3 class="text-lg font-semibold text-gray-900 dark:text-white mb-4">Menu Items</h3>
    <div id="menu-items" class="space-y-2">
        <p class="text-gray-500 dark:text-gray-400 text-center py-8">No menu items yet. Add your first menu item above.</p>
    </div>
</div>

<?php $__env->startPush('scripts'); ?>
<script src="https://cdn.jsdelivr.net/npm/sortablejs@latest/Sortable.min.js"></script>
<script>
// TODO: Implement drag-and-drop with Sortable.js
// const sortable = new Sortable(document.getElementById('menu-items'), {
//     animation: 150,
//     onEnd: function(evt) {
//         // Update order via AJAX
//     }
// });
</script>
<?php $__env->stopPush(); ?>
<?php $__env->stopSection(); ?>


<?php echo $__env->make('admin.layouts.app', array_diff_key(get_defined_vars(), ['__data' => 1, '__path' => 1]))->render(); ?><?php /**PATH C:\xampp\htdocs\linkie-dev\resources\views/admin/navigation/index.blade.php ENDPATH**/ ?>