

<?php $__env->startSection('title', 'Linkie.dev - Technical Blog & Product Showcase'); ?>

<?php $__env->startSection('content'); ?>

<section class="relative bg-gradient-to-br from-[#1E3A8A] via-[#121212] to-[#121212] py-20 lg:py-32">
    <div class="max-w-7xl mx-auto px-4 sm:px-6 lg:px-8">
        <div class="text-center">
            
            <h1 class="text-5xl md:text-7xl font-black font-heading text-white mb-6 leading-tight">
                Welcome to <span class="text-[#00B4D8]">Linkie.dev</span>
            </h1>
            
            
            <p class="text-xl md:text-2xl text-[#E0E0E0]/80 mb-8 max-w-3xl mx-auto">
                Your destination for technical tutorials, product reviews, and premium tools. Learn, explore, and build amazing things.
            </p>

            
            <div class="flex flex-col sm:flex-row gap-4 justify-center">
                
                <a href="<?php echo e(route('blog.index')); ?>" 
                   class="px-8 py-4 bg-[#00B4D8] text-white font-bold rounded-lg hover:bg-[#00B4D8]/80 transition-colors shadow-lg shadow-[#00B4D8]/30">
                    Start Learning
                </a>
                
                
                <a href="<?php echo e(route('products.index')); ?>" 
                   class="px-8 py-4 border-2 border-[#00B4D8] text-[#00B4D8] font-bold rounded-lg hover:bg-[#00B4D8]/10 transition-colors">
                    Explore Tools
                </a>
            </div>
        </div>
    </div>
</section>


<section class="py-16 bg-[#121212]">
    <div class="max-w-7xl mx-auto px-4 sm:px-6 lg:px-8">
        
        <div class="flex justify-between items-center mb-12">
            <h2 class="text-4xl font-bold font-heading text-[#E0E0E0]">Latest Blog Posts</h2>
            <a href="<?php echo e(route('blog.index')); ?>" class="text-[#00B4D8] hover:text-[#00B4D8]/80 font-semibold transition-colors">
                View All →
            </a>
        </div>

        
        <?php if($latestPosts->count() > 0): ?>
            <div class="grid grid-cols-1 md:grid-cols-2 lg:grid-cols-3 gap-8">
                <?php $__currentLoopData = $latestPosts; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $post): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                    <?php if (isset($component)) { $__componentOriginalef84dbe2113ee1aa06beffddb73fe07d = $component; } ?>
<?php if (isset($attributes)) { $__attributesOriginalef84dbe2113ee1aa06beffddb73fe07d = $attributes; } ?>
<?php $component = Illuminate\View\AnonymousComponent::resolve(['view' => 'components.blog-card','data' => ['post' => $post]] + (isset($attributes) && $attributes instanceof Illuminate\View\ComponentAttributeBag ? $attributes->all() : [])); ?>
<?php $component->withName('blog-card'); ?>
<?php if ($component->shouldRender()): ?>
<?php $__env->startComponent($component->resolveView(), $component->data()); ?>
<?php if (isset($attributes) && $attributes instanceof Illuminate\View\ComponentAttributeBag): ?>
<?php $attributes = $attributes->except(\Illuminate\View\AnonymousComponent::ignoredParameterNames()); ?>
<?php endif; ?>
<?php $component->withAttributes(['post' => \Illuminate\View\Compilers\BladeCompiler::sanitizeComponentAttribute($post)]); ?>
<?php echo $__env->renderComponent(); ?>
<?php endif; ?>
<?php if (isset($__attributesOriginalef84dbe2113ee1aa06beffddb73fe07d)): ?>
<?php $attributes = $__attributesOriginalef84dbe2113ee1aa06beffddb73fe07d; ?>
<?php unset($__attributesOriginalef84dbe2113ee1aa06beffddb73fe07d); ?>
<?php endif; ?>
<?php if (isset($__componentOriginalef84dbe2113ee1aa06beffddb73fe07d)): ?>
<?php $component = $__componentOriginalef84dbe2113ee1aa06beffddb73fe07d; ?>
<?php unset($__componentOriginalef84dbe2113ee1aa06beffddb73fe07d); ?>
<?php endif; ?>
                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
            </div>
        <?php else: ?>
            
            <div class="text-center py-12">
                <p class="text-[#E0E0E0]/50 text-lg">No blog posts yet. Check back soon!</p>
            </div>
        <?php endif; ?>
    </div>
</section>


<section class="py-16 bg-[#0a0a0a]">
    <div class="max-w-7xl mx-auto px-4 sm:px-6 lg:px-8">
        
        <div class="flex justify-between items-center mb-12">
            <h2 class="text-4xl font-bold font-heading text-[#E0E0E0]">Featured Products</h2>
            <a href="<?php echo e(route('products.index')); ?>" class="text-[#00B4D8] hover:text-[#00B4D8]/80 font-semibold transition-colors">
                View All →
            </a>
        </div>

        
        <?php if($featuredProducts->count() > 0): ?>
            <div class="grid grid-cols-1 md:grid-cols-2 lg:grid-cols-3 gap-8">
                <?php $__currentLoopData = $featuredProducts; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $product): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                    <?php if (isset($component)) { $__componentOriginal3fd2897c1d6a149cdb97b41db9ff827a = $component; } ?>
<?php if (isset($attributes)) { $__attributesOriginal3fd2897c1d6a149cdb97b41db9ff827a = $attributes; } ?>
<?php $component = Illuminate\View\AnonymousComponent::resolve(['view' => 'components.product-card','data' => ['product' => $product]] + (isset($attributes) && $attributes instanceof Illuminate\View\ComponentAttributeBag ? $attributes->all() : [])); ?>
<?php $component->withName('product-card'); ?>
<?php if ($component->shouldRender()): ?>
<?php $__env->startComponent($component->resolveView(), $component->data()); ?>
<?php if (isset($attributes) && $attributes instanceof Illuminate\View\ComponentAttributeBag): ?>
<?php $attributes = $attributes->except(\Illuminate\View\AnonymousComponent::ignoredParameterNames()); ?>
<?php endif; ?>
<?php $component->withAttributes(['product' => \Illuminate\View\Compilers\BladeCompiler::sanitizeComponentAttribute($product)]); ?>
<?php echo $__env->renderComponent(); ?>
<?php endif; ?>
<?php if (isset($__attributesOriginal3fd2897c1d6a149cdb97b41db9ff827a)): ?>
<?php $attributes = $__attributesOriginal3fd2897c1d6a149cdb97b41db9ff827a; ?>
<?php unset($__attributesOriginal3fd2897c1d6a149cdb97b41db9ff827a); ?>
<?php endif; ?>
<?php if (isset($__componentOriginal3fd2897c1d6a149cdb97b41db9ff827a)): ?>
<?php $component = $__componentOriginal3fd2897c1d6a149cdb97b41db9ff827a; ?>
<?php unset($__componentOriginal3fd2897c1d6a149cdb97b41db9ff827a); ?>
<?php endif; ?>
                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
            </div>
        <?php else: ?>
            
            <div class="text-center py-12">
                <p class="text-[#E0E0E0]/50 text-lg">No products yet. Check back soon!</p>
            </div>
        <?php endif; ?>
    </div>
</section>


<section class="py-16 bg-[#121212]">
    <div class="max-w-4xl mx-auto px-4 sm:px-6 lg:px-8 text-center">
        <h2 class="text-3xl font-bold font-heading text-[#E0E0E0] mb-6">About Linkie.dev</h2>
        <p class="text-lg text-[#E0E0E0]/70 mb-8 max-w-2xl mx-auto">
            We're passionate about technology and helping developers build amazing things. 
            From in-depth tutorials to premium tools and templates, we've got you covered.
        </p>
        <a href="<?php echo e(route('about.index')); ?>" 
           class="inline-block px-6 py-3 bg-[#00B4D8] text-white font-semibold rounded-lg hover:bg-[#00B4D8]/80 transition-colors">
            Learn More
        </a>
    </div>
</section>
<?php $__env->stopSection(); ?>


<?php echo $__env->make('layouts.main', array_diff_key(get_defined_vars(), ['__data' => 1, '__path' => 1]))->render(); ?><?php /**PATH C:\xampp\htdocs\linkie-dev\resources\views/home.blade.php ENDPATH**/ ?>