

<?php $__env->startSection('title', 'Content Importer'); ?>

<?php $__env->startSection('content'); ?>

<div class="max-w-7xl mx-auto">
    
    <div class="mb-8">
        <h1 class="text-3xl font-heading font-bold text-gray-900 dark:text-white mb-2">
            Content Importer
        </h1>
        <p class="text-gray-600 dark:text-gray-400">
            Import content from JSON, Markdown, HTML, Laravel Seeder, or plain text formats. Auto-detection available.
        </p>
    </div>

    
    <div class="bg-white dark:bg-gray-800 rounded-lg shadow-lg p-6 lg:p-8">
        <form id="importForm" class="space-y-6">
            <?php echo csrf_field(); ?>

            
            <div>
                <label class="block text-sm font-semibold text-gray-700 dark:text-gray-300 mb-3">
                    Content Format
                </label>
                <div class="grid grid-cols-2 md:grid-cols-3 lg:grid-cols-6 gap-3">
                    <label class="flex items-center p-3 border-2 border-gray-300 dark:border-gray-600 rounded-lg cursor-pointer hover:border-cyan-500 dark:hover:border-cyan-500 transition-colors">
                        <input type="radio" name="format" value="auto" checked class="mr-2 text-cyan-500 focus:ring-cyan-500">
                        <span class="text-sm text-gray-700 dark:text-gray-300">Auto-detect</span>
                    </label>
                    <label class="flex items-center p-3 border-2 border-gray-300 dark:border-gray-600 rounded-lg cursor-pointer hover:border-cyan-500 dark:hover:border-cyan-500 transition-colors">
                        <input type="radio" name="format" value="json" class="mr-2 text-cyan-500 focus:ring-cyan-500">
                        <span class="text-sm text-gray-700 dark:text-gray-300">JSON</span>
                    </label>
                    <label class="flex items-center p-3 border-2 border-gray-300 dark:border-gray-600 rounded-lg cursor-pointer hover:border-cyan-500 dark:hover:border-cyan-500 transition-colors">
                        <input type="radio" name="format" value="markdown" class="mr-2 text-cyan-500 focus:ring-cyan-500">
                        <span class="text-sm text-gray-700 dark:text-gray-300">Markdown</span>
                    </label>
                    <label class="flex items-center p-3 border-2 border-gray-300 dark:border-gray-600 rounded-lg cursor-pointer hover:border-cyan-500 dark:hover:border-cyan-500 transition-colors">
                        <input type="radio" name="format" value="html" class="mr-2 text-cyan-500 focus:ring-cyan-500">
                        <span class="text-sm text-gray-700 dark:text-gray-300">HTML</span>
                    </label>
                    <label class="flex items-center p-3 border-2 border-gray-300 dark:border-gray-600 rounded-lg cursor-pointer hover:border-cyan-500 dark:hover:border-cyan-500 transition-colors">
                        <input type="radio" name="format" value="seeder" class="mr-2 text-cyan-500 focus:ring-cyan-500">
                        <span class="text-sm text-gray-700 dark:text-gray-300">Seeder</span>
                    </label>
                    <label class="flex items-center p-3 border-2 border-gray-300 dark:border-gray-600 rounded-lg cursor-pointer hover:border-cyan-500 dark:hover:border-cyan-500 transition-colors">
                        <input type="radio" name="format" value="text" class="mr-2 text-cyan-500 focus:ring-cyan-500">
                        <span class="text-sm text-gray-700 dark:text-gray-300">Text</span>
                    </label>
                </div>
            </div>

            
            <div>
                <label for="content" class="block text-sm font-semibold text-gray-700 dark:text-gray-300 mb-2">
                    Content
                </label>
                <textarea 
                    id="content" 
                    name="content" 
                    rows="15" 
                    required
                    class="w-full px-4 py-3 bg-gray-50 dark:bg-gray-700 border border-gray-300 dark:border-gray-600 rounded-lg text-gray-900 dark:text-gray-100 font-mono text-sm focus:outline-none focus:ring-2 focus:ring-cyan-500 focus:border-transparent resize-y"
                    placeholder="Paste or type your content here..."></textarea>
                <p class="mt-2 text-xs text-gray-500 dark:text-gray-400">
                    You can paste content in any format. The system will auto-detect the format if "Auto-detect" is selected.
                </p>
            </div>

            
            <div class="flex items-center justify-end space-x-4">
                <button 
                    type="button" 
                    onclick="clearForm()"
                    class="px-6 py-2.5 bg-gray-200 dark:bg-gray-700 text-gray-700 dark:text-gray-300 rounded-lg hover:bg-gray-300 dark:hover:bg-gray-600 transition-colors font-medium">
                    Clear
                </button>
                <button 
                    type="submit" 
                    id="parseBtn"
                    class="px-6 py-2.5 bg-cyan-500 hover:bg-cyan-600 text-white rounded-lg transition-colors font-medium flex items-center space-x-2">
                    <span>Parse Content</span>
                    <svg id="loadingSpinner" class="hidden w-5 h-5 animate-spin" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                        <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M4 4v5h.582m15.356 2A8.001 8.001 0 004.582 9m0 0H9m11 11v-5h-.581m0 0a8.003 8.003 0 01-15.357-2m15.357 2H15" />
                    </svg>
                </button>
            </div>
        </form>
    </div>

    
    <div class="mt-8 bg-white dark:bg-gray-800 rounded-lg shadow-lg p-6 lg:p-8" x-data="{ open: false }">
        <button 
            @click="open = !open"
            class="w-full flex items-center justify-between text-left">
            <h2 class="text-xl font-heading font-semibold text-gray-900 dark:text-white">
                Example Formats
            </h2>
            <svg class="w-5 h-5 text-gray-500 dark:text-gray-400 transform transition-transform" :class="{ 'rotate-180': open }" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M19 9l-7 7-7-7" />
            </svg>
        </button>

        <div x-show="open" 
             x-transition:enter="transition ease-out duration-200"
             x-transition:enter-start="opacity-0 transform scale-95"
             x-transition:enter-end="opacity-100 transform scale-100"
             x-transition:leave="transition ease-in duration-150"
             x-transition:leave-start="opacity-100 transform scale-100"
             x-transition:leave-end="opacity-0 transform scale-95"
             class="mt-6 space-y-4"
             style="display: none;">
            
            <div class="border-l-4 border-cyan-500 pl-4">
                <h3 class="font-semibold text-gray-900 dark:text-white mb-2">JSON Example</h3>
                <pre class="bg-gray-900 dark:bg-gray-900 text-gray-100 p-4 rounded text-xs overflow-x-auto"><code>{
  "title": "Product Review",
  "summary": "A comprehensive review...",
  "content_html": "&lt;p&gt;Content here...&lt;/p&gt;",
  "pros": ["Feature 1", "Feature 2"],
  "cons": ["Issue 1"],
  "affiliate_link": "https://example.com"
}</code></pre>
            </div>

            
            <div class="border-l-4 border-cyan-500 pl-4">
                <h3 class="font-semibold text-gray-900 dark:text-white mb-2">Markdown Example</h3>
                <pre class="bg-gray-900 dark:bg-gray-900 text-gray-100 p-4 rounded text-xs overflow-x-auto"><code># Product Title

Summary paragraph here.

## Pros
- Feature 1
- Feature 2

## Cons
- Issue 1</code></pre>
            </div>
        </div>
    </div>
</div>

<?php $__env->startPush('scripts'); ?>
<script>
    document.getElementById('importForm').addEventListener('submit', async function(e) {
        e.preventDefault();
        
        const formData = new FormData(this);
        const parseBtn = document.getElementById('parseBtn');
        const loadingSpinner = document.getElementById('loadingSpinner');
        
        // Show loading state
        parseBtn.disabled = true;
        loadingSpinner.classList.remove('hidden');
        
        try {
            const response = await fetch('<?php echo e(route("admin.import.parse")); ?>', {
                method: 'POST',
                headers: {
                    'X-CSRF-TOKEN': document.querySelector('meta[name="csrf-token"]').content,
                    'Accept': 'application/json',
                },
                body: formData
            });
            
            const data = await response.json();
            
            if (data.success) {
                // Redirect to preview page
                window.location.href = '<?php echo e(route("admin.import.preview")); ?>';
            } else {
                alert('Error: ' + (data.message || 'Failed to parse content'));
            }
        } catch (error) {
            alert('Error: ' + error.message);
        } finally {
            parseBtn.disabled = false;
            loadingSpinner.classList.add('hidden');
        }
    });
    
    function clearForm() {
        document.getElementById('content').value = '';
    }
</script>
<?php $__env->stopPush(); ?>
<?php $__env->stopSection(); ?>


<?php echo $__env->make('admin.layouts.app', array_diff_key(get_defined_vars(), ['__data' => 1, '__path' => 1]))->render(); ?><?php /**PATH C:\xampp\htdocs\linkie-dev\resources\views/admin/import/index.blade.php ENDPATH**/ ?>