

<?php $__env->startSection('title', 'Posts - Admin'); ?>

<?php $__env->startSection('content'); ?>
<div class="flex justify-between items-center mb-8">
    <h1 class="text-4xl font-bold font-heading text-white">Posts</h1>
    <a href="<?php echo e(route('admin.posts.create')); ?>" 
       class="px-6 py-3 bg-[#00B4D8] text-white font-semibold rounded-lg hover:bg-[#00B4D8]/80 transition-colors">
        Create New Post
    </a>
</div>


<div class="bg-[#1a1a1a] border border-gray-800 rounded-lg overflow-hidden">
    <table class="w-full">
        <thead class="bg-gray-900">
            <tr>
                <th class="px-6 py-4 text-left text-sm font-semibold text-[#E0E0E0]">Title</th>
                <th class="px-6 py-4 text-left text-sm font-semibold text-[#E0E0E0]">Category</th>
                <th class="px-6 py-4 text-left text-sm font-semibold text-[#E0E0E0]">Status</th>
                <th class="px-6 py-4 text-left text-sm font-semibold text-[#E0E0E0]">Created</th>
                <th class="px-6 py-4 text-right text-sm font-semibold text-[#E0E0E0]">Actions</th>
            </tr>
        </thead>
        <tbody class="divide-y divide-gray-800">
            <?php $__empty_1 = true; $__currentLoopData = $posts; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $post): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); $__empty_1 = false; ?>
                <tr class="hover:bg-gray-800/50 transition-colors">
                    <td class="px-6 py-4">
                        <a href="<?php echo e(route('admin.posts.show', $post)); ?>" class="text-[#E0E0E0] hover:text-[#00B4D8] transition-colors">
                            <?php echo e($post->title); ?>

                        </a>
                    </td>
                    <td class="px-6 py-4 text-[#E0E0E0]/70"><?php echo e($post->category ?? '—'); ?></td>
                    <td class="px-6 py-4">
                        <?php if($post->published_at && $post->published_at <= now()): ?>
                            <span class="px-3 py-1 text-xs font-semibold bg-green-500/20 text-green-400 rounded-full">Published</span>
                        <?php else: ?>
                            <span class="px-3 py-1 text-xs font-semibold bg-yellow-500/20 text-yellow-400 rounded-full">Draft</span>
                        <?php endif; ?>
                    </td>
                    <td class="px-6 py-4 text-[#E0E0E0]/70 text-sm"><?php echo e($post->created_at->format('M d, Y')); ?></td>
                    <td class="px-6 py-4 text-right">
                        <div class="flex justify-end space-x-2">
                            <a href="<?php echo e(route('admin.posts.edit', $post)); ?>" 
                               class="px-3 py-1 text-sm bg-gray-700 text-[#E0E0E0] rounded hover:bg-gray-600 transition-colors">
                                Edit
                            </a>
                            <form action="<?php echo e(route('admin.posts.destroy', $post)); ?>" method="POST" class="inline" 
                                  onsubmit="return confirm('Are you sure you want to delete this post?');">
                                <?php echo csrf_field(); ?>
                                <?php echo method_field('DELETE'); ?>
                                <button type="submit" 
                                        class="px-3 py-1 text-sm bg-red-600 text-white rounded hover:bg-red-700 transition-colors">
                                    Delete
                                </button>
                            </form>
                        </div>
                    </td>
                </tr>
            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); if ($__empty_1): ?>
                <tr>
                    <td colspan="5" class="px-6 py-12 text-center text-[#E0E0E0]/50">
                        No posts found. <a href="<?php echo e(route('admin.posts.create')); ?>" class="text-[#00B4D8] hover:underline">Create one</a>
                    </td>
                </tr>
            <?php endif; ?>
        </tbody>
    </table>
</div>


<div class="mt-6">
    <?php echo e($posts->links()); ?>

</div>
<?php $__env->stopSection(); ?>


<?php echo $__env->make('layouts.admin', array_diff_key(get_defined_vars(), ['__data' => 1, '__path' => 1]))->render(); ?><?php /**PATH C:\xampp\htdocs\linkie-dev\resources\views/admin/posts/index.blade.php ENDPATH**/ ?>