

<?php $__env->startSection('title', $post->title . ' - View Post'); ?>

<?php $__env->startSection('page-header'); ?>
<div class="flex items-center justify-between">
    <div>
        <h1 class="text-3xl font-bold text-gray-900 dark:text-white"><?php echo e($post->title); ?></h1>
        <p class="mt-1 text-sm text-gray-500 dark:text-gray-400">View post details</p>
    </div>
    <div class="flex items-center space-x-3">
        <a href="<?php echo e(route('admin.content.posts.edit', $post)); ?>" 
           class="inline-flex items-center px-4 py-2 bg-gray-200 dark:bg-gray-700 hover:bg-gray-300 dark:hover:bg-gray-600 text-gray-700 dark:text-gray-300 font-medium rounded-lg transition-colors">
            <svg class="w-5 h-5 mr-2" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M11 5H6a2 2 0 00-2 2v11a2 2 0 002 2h11a2 2 0 002-2v-5m-1.414-9.414a2 2 0 112.828 2.828L11.828 15H9v-2.828l8.586-8.586z" />
            </svg>
            Edit
        </a>
        <a href="<?php echo e(route('admin.content.posts.index')); ?>" 
           class="inline-flex items-center px-4 py-2 bg-gray-200 dark:bg-gray-700 hover:bg-gray-300 dark:hover:bg-gray-600 text-gray-700 dark:text-gray-300 font-medium rounded-lg transition-colors">
            <svg class="w-5 h-5 mr-2" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M10 19l-7-7m0 0l7-7m-7 7h18" />
            </svg>
            Back to Posts
        </a>
    </div>
</div>
<?php $__env->stopSection(); ?>

<?php $__env->startSection('content'); ?>
<div class="space-y-6">
    
    <div class="bg-white dark:bg-gray-800 rounded-lg shadow-sm border border-gray-200 dark:border-gray-700 overflow-hidden">
        
        <div class="px-6 py-4 border-b border-gray-200 dark:border-gray-700 bg-gray-50 dark:bg-gray-700">
            <div class="flex items-center justify-between">
                <div class="flex items-center space-x-4">
                    <span class="inline-flex items-center px-3 py-1 rounded-full text-xs font-medium 
                        <?php echo e($post->published_at ? 'bg-green-100 text-green-800 dark:bg-green-900 dark:text-green-200' : 'bg-gray-100 text-gray-800 dark:bg-gray-700 dark:text-gray-300'); ?>">
                        <?php echo e($post->published_at ? 'Published' : 'Draft'); ?>

                    </span>
                    <?php if($post->category): ?>
                        <span class="inline-flex items-center px-3 py-1 rounded-full text-xs font-medium bg-cyan-100 text-cyan-800 dark:bg-cyan-900 dark:text-cyan-200">
                            <?php echo e($post->category); ?>

                        </span>
                    <?php endif; ?>
                </div>
                <div class="text-sm text-gray-500 dark:text-gray-400">
                    Created: <?php echo e($post->created_at->format('M d, Y')); ?>

                    <?php if($post->published_at): ?>
                        | Published: <?php echo e($post->published_at->format('M d, Y')); ?>

                    <?php endif; ?>
                </div>
            </div>
        </div>

        
        <div class="p-6 lg:p-8">
            
            <?php if($post->featured_image): ?>
                <div class="mb-6">
                    <img src="<?php echo e(Storage::url($post->featured_image)); ?>" 
                         alt="<?php echo e($post->title); ?>" 
                         class="w-full h-auto rounded-lg shadow-md">
                </div>
            <?php endif; ?>

            
            <h2 class="text-2xl font-heading font-bold text-gray-900 dark:text-white mb-4">
                <?php echo e($post->title); ?>

            </h2>

            
            <?php if($post->excerpt): ?>
                <div class="mb-6 p-4 bg-gray-50 dark:bg-gray-700 rounded-lg border-l-4 border-cyan-500">
                    <p class="text-gray-700 dark:text-gray-300 italic"><?php echo e($post->excerpt); ?></p>
                </div>
            <?php endif; ?>

            
            <div class="prose dark:prose-invert max-w-none mb-6">
                <?php echo $post->content; ?>

            </div>

            
            <div class="mt-8 pt-6 border-t border-gray-200 dark:border-gray-700">
                <h3 class="text-lg font-semibold text-gray-900 dark:text-white mb-4">SEO Information</h3>
                <div class="grid md:grid-cols-2 gap-4">
                    <div>
                        <label class="block text-sm font-medium text-gray-700 dark:text-gray-300 mb-1">Meta Title</label>
                        <p class="text-sm text-gray-600 dark:text-gray-400"><?php echo e($post->meta_title ?: 'Not set'); ?></p>
                    </div>
                    <div>
                        <label class="block text-sm font-medium text-gray-700 dark:text-gray-300 mb-1">Slug</label>
                        <p class="text-sm text-gray-600 dark:text-gray-400 font-mono"><?php echo e($post->slug); ?></p>
                    </div>
                    <div class="md:col-span-2">
                        <label class="block text-sm font-medium text-gray-700 dark:text-gray-300 mb-1">Meta Description</label>
                        <p class="text-sm text-gray-600 dark:text-gray-400"><?php echo e($post->meta_description ?: 'Not set'); ?></p>
                    </div>
                </div>
            </div>

            
            <div class="mt-8 pt-6 border-t border-gray-200 dark:border-gray-700 flex items-center justify-between">
                <div class="flex items-center space-x-4">
                    <?php if($post->published_at): ?>
                        <form action="<?php echo e(route('admin.content.posts.unpublish', $post)); ?>" method="POST" class="inline">
                            <?php echo csrf_field(); ?>
                            <button type="submit" 
                                    class="inline-flex items-center px-4 py-2 bg-yellow-500 hover:bg-yellow-600 text-white font-medium rounded-lg transition-colors">
                                <svg class="w-5 h-5 mr-2" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                                    <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M18.364 18.364A9 9 0 005.636 5.636m12.728 12.728A9 9 0 015.636 5.636m12.728 12.728L5.636 5.636" />
                                </svg>
                                Unpublish
                            </button>
                        </form>
                    <?php else: ?>
                        <form action="<?php echo e(route('admin.content.posts.publish', $post)); ?>" method="POST" class="inline">
                            <?php echo csrf_field(); ?>
                            <button type="submit" 
                                    class="inline-flex items-center px-4 py-2 bg-green-500 hover:bg-green-600 text-white font-medium rounded-lg transition-colors">
                                <svg class="w-5 h-5 mr-2" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                                    <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M5 13l4 4L19 7" />
                                </svg>
                                Publish
                            </button>
                        </form>
                    <?php endif; ?>
                </div>
                <form action="<?php echo e(route('admin.content.posts.destroy', $post)); ?>" method="POST" class="inline" 
                      onsubmit="return confirm('Are you sure you want to delete this post? This action cannot be undone.');">
                    <?php echo csrf_field(); ?>
                    <?php echo method_field('DELETE'); ?>
                    <button type="submit" 
                            class="inline-flex items-center px-4 py-2 bg-red-500 hover:bg-red-600 text-white font-medium rounded-lg transition-colors">
                        <svg class="w-5 h-5 mr-2" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                            <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M19 7l-.867 12.142A2 2 0 0116.138 21H7.862a2 2 0 01-1.995-1.858L5 7m5 4v6m4-6v6m1-10V4a1 1 0 00-1-1h-4a1 1 0 00-1 1v3M4 7h16" />
                        </svg>
                        Delete
                    </button>
                </form>
            </div>
        </div>
    </div>

    
    <?php if($post->published_at): ?>
        <div class="bg-cyan-50 dark:bg-cyan-900/20 border border-cyan-200 dark:border-cyan-800 rounded-lg p-4">
            <div class="flex items-center justify-between">
                <div>
                    <p class="text-sm font-medium text-cyan-900 dark:text-cyan-200">This post is published and visible to the public.</p>
                    <p class="text-xs text-cyan-700 dark:text-cyan-300 mt-1">View it on the frontend:</p>
                </div>
                <a href="<?php echo e(route('blog.show', $post->slug)); ?>" 
                   target="_blank"
                   class="inline-flex items-center px-4 py-2 bg-cyan-500 hover:bg-cyan-600 text-white font-medium rounded-lg transition-colors">
                    <svg class="w-5 h-5 mr-2" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                        <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M10 6H6a2 2 0 00-2 2v10a2 2 0 002 2h10a2 2 0 002-2v-4M14 4h6m0 0v6m0-6L10 14" />
                    </svg>
                    View Post
                </a>
            </div>
        </div>
    <?php endif; ?>
</div>
<?php $__env->stopSection(); ?>


<?php echo $__env->make('admin.layouts.app', array_diff_key(get_defined_vars(), ['__data' => 1, '__path' => 1]))->render(); ?><?php /**PATH C:\xampp\htdocs\linkie-dev\resources\views/admin/content/posts/show.blade.php ENDPATH**/ ?>