

<?php $__env->startSection('title', 'Blog - Linkie.dev'); ?>

<?php $__env->startSection('content'); ?>

<section class="py-12 bg-[#121212]">
    <div class="max-w-7xl mx-auto px-4 sm:px-6 lg:px-8">
        
        <div class="text-center mb-12">
            <h1 class="text-5xl font-black font-heading text-white mb-4">
                Technical <span class="text-[#00B4D8]">Blog</span>
            </h1>
            <p class="text-xl text-[#E0E0E0]/70 max-w-2xl mx-auto">
                Explore our latest tutorials, reviews, and technical insights
            </p>
        </div>

        
        <?php if($categories->count() > 0): ?>
            
            <div class="flex flex-wrap gap-3 justify-center mb-12">
                
                <a href="<?php echo e(route('blog.index')); ?>" 
                   class="px-6 py-2 rounded-full border-2 <?php echo e(!request('category') ? 'border-[#00B4D8] bg-[#00B4D8]/10 text-[#00B4D8]' : 'border-gray-700 text-[#E0E0E0]/70 hover:border-[#00B4D8]'); ?> transition-colors font-semibold">
                    All
                </a>
                
                
                <?php $__currentLoopData = $categories; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $category): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                    <a href="<?php echo e(route('blog.index', ['category' => $category])); ?>" 
                       class="px-6 py-2 rounded-full border-2 <?php echo e(request('category') == $category ? 'border-[#00B4D8] bg-[#00B4D8]/10 text-[#00B4D8]' : 'border-gray-700 text-[#E0E0E0]/70 hover:border-[#00B4D8]'); ?> transition-colors font-semibold">
                        <?php echo e($category); ?>

                    </a>
                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
            </div>
        <?php endif; ?>

        
        <?php if($posts->count() > 0): ?>
            <div class="grid grid-cols-1 md:grid-cols-2 lg:grid-cols-3 gap-8 mb-12">
                <?php $__currentLoopData = $posts; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $post): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                    <?php if (isset($component)) { $__componentOriginalef84dbe2113ee1aa06beffddb73fe07d = $component; } ?>
<?php if (isset($attributes)) { $__attributesOriginalef84dbe2113ee1aa06beffddb73fe07d = $attributes; } ?>
<?php $component = Illuminate\View\AnonymousComponent::resolve(['view' => 'components.blog-card','data' => ['post' => $post]] + (isset($attributes) && $attributes instanceof Illuminate\View\ComponentAttributeBag ? $attributes->all() : [])); ?>
<?php $component->withName('blog-card'); ?>
<?php if ($component->shouldRender()): ?>
<?php $__env->startComponent($component->resolveView(), $component->data()); ?>
<?php if (isset($attributes) && $attributes instanceof Illuminate\View\ComponentAttributeBag): ?>
<?php $attributes = $attributes->except(\Illuminate\View\AnonymousComponent::ignoredParameterNames()); ?>
<?php endif; ?>
<?php $component->withAttributes(['post' => \Illuminate\View\Compilers\BladeCompiler::sanitizeComponentAttribute($post)]); ?>
<?php echo $__env->renderComponent(); ?>
<?php endif; ?>
<?php if (isset($__attributesOriginalef84dbe2113ee1aa06beffddb73fe07d)): ?>
<?php $attributes = $__attributesOriginalef84dbe2113ee1aa06beffddb73fe07d; ?>
<?php unset($__attributesOriginalef84dbe2113ee1aa06beffddb73fe07d); ?>
<?php endif; ?>
<?php if (isset($__componentOriginalef84dbe2113ee1aa06beffddb73fe07d)): ?>
<?php $component = $__componentOriginalef84dbe2113ee1aa06beffddb73fe07d; ?>
<?php unset($__componentOriginalef84dbe2113ee1aa06beffddb73fe07d); ?>
<?php endif; ?>
                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
            </div>

            
            <div class="flex justify-center">
                <?php echo e($posts->links()); ?>

            </div>
        <?php else: ?>
            
            <div class="text-center py-16">
                <p class="text-[#E0E0E0]/50 text-xl mb-4">No blog posts found.</p>
                <?php if(request('category')): ?>
                    <a href="<?php echo e(route('blog.index')); ?>" class="text-[#00B4D8] hover:text-[#00B4D8]/80 font-semibold">
                        View all posts →
                    </a>
                <?php endif; ?>
            </div>
        <?php endif; ?>
    </div>
</section>
<?php $__env->stopSection(); ?>


<?php echo $__env->make('layouts.main', array_diff_key(get_defined_vars(), ['__data' => 1, '__path' => 1]))->render(); ?><?php /**PATH C:\xampp\htdocs\linkie-dev\resources\views/blog/index.blade.php ENDPATH**/ ?>