

<?php $__env->startSection('title', 'Create Post - Admin'); ?>

<?php $__env->startSection('content'); ?>

<div class="mb-8">
    
    <h1 class="text-4xl font-bold font-heading text-white">Create New Post</h1>
    
    <a href="<?php echo e(route('admin.posts.index')); ?>" class="text-[#00B4D8] hover:text-[#00B4D8]/80 mt-2 inline-block">
        ← Back to Posts
    </a>
</div>


<form action="<?php echo e(route('admin.posts.store')); ?>" method="POST" enctype="multipart/form-data" class="bg-[#1a1a1a] border border-gray-800 rounded-lg p-8">
    <?php echo csrf_field(); ?>

    
    <div class="space-y-6">
        
        <div>
            
            <label for="title" class="block text-[#E0E0E0] font-semibold mb-2">Title *</label>
            
            <input type="text" id="title" name="title" value="<?php echo e(old('title')); ?>" required
                   class="w-full px-4 py-3 bg-[#121212] border border-gray-700 rounded-lg text-[#E0E0E0] focus:outline-none focus:border-[#00B4D8]">
            
            <?php $__errorArgs = ['title'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?><p class="mt-2 text-sm text-red-500"><?php echo e($message); ?></p><?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
        </div>

        
        <div>
            <label for="slug" class="block text-[#E0E0E0] font-semibold mb-2">Slug (auto-generated if empty)</label>
            <input type="text" id="slug" name="slug" value="<?php echo e(old('slug')); ?>"
                   class="w-full px-4 py-3 bg-[#121212] border border-gray-700 rounded-lg text-[#E0E0E0] focus:outline-none focus:border-[#00B4D8]">
            <?php $__errorArgs = ['slug'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?><p class="mt-2 text-sm text-red-500"><?php echo e($message); ?></p><?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
        </div>

        
        <div>
            <label for="category" class="block text-[#E0E0E0] font-semibold mb-2">Category</label>
            <input type="text" id="category" name="category" value="<?php echo e(old('category')); ?>"
                   class="w-full px-4 py-3 bg-[#121212] border border-gray-700 rounded-lg text-[#E0E0E0] focus:outline-none focus:border-[#00B4D8]">
            <?php $__errorArgs = ['category'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?><p class="mt-2 text-sm text-red-500"><?php echo e($message); ?></p><?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
        </div>

        
        <div>
            <label for="excerpt" class="block text-[#E0E0E0] font-semibold mb-2">Excerpt</label>
            <textarea id="excerpt" name="excerpt" rows="3"
                      class="w-full px-4 py-3 bg-[#121212] border border-gray-700 rounded-lg text-[#E0E0E0] focus:outline-none focus:border-[#00B4D8] resize-none"><?php echo e(old('excerpt')); ?></textarea>
            <?php $__errorArgs = ['excerpt'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?><p class="mt-2 text-sm text-red-500"><?php echo e($message); ?></p><?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
        </div>

        
        <div>
            <label for="content" class="block text-[#E0E0E0] font-semibold mb-2">Content *</label>
            <textarea id="content" name="content" rows="12" required
                      class="w-full px-4 py-3 bg-[#121212] border border-gray-700 rounded-lg text-[#E0E0E0] focus:outline-none focus:border-[#00B4D8] resize-none"><?php echo e(old('content')); ?></textarea>
            <?php $__errorArgs = ['content'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?><p class="mt-2 text-sm text-red-500"><?php echo e($message); ?></p><?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
        </div>

        
        <div>
            <label for="featured_image" class="block text-[#E0E0E0] font-semibold mb-2">Featured Image</label>
            <input type="file" id="featured_image" name="featured_image" accept="image/*"
                   class="w-full px-4 py-3 bg-[#121212] border border-gray-700 rounded-lg text-[#E0E0E0] focus:outline-none focus:border-[#00B4D8]">
            <?php $__errorArgs = ['featured_image'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?><p class="mt-2 text-sm text-red-500"><?php echo e($message); ?></p><?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
        </div>

        
        <div>
            <label for="meta_title" class="block text-[#E0E0E0] font-semibold mb-2">SEO Meta Title</label>
            <input type="text" id="meta_title" name="meta_title" value="<?php echo e(old('meta_title')); ?>"
                   class="w-full px-4 py-3 bg-[#121212] border border-gray-700 rounded-lg text-[#E0E0E0] focus:outline-none focus:border-[#00B4D8]">
            <?php $__errorArgs = ['meta_title'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?><p class="mt-2 text-sm text-red-500"><?php echo e($message); ?></p><?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
        </div>

        
        <div>
            <label for="meta_description" class="block text-[#E0E0E0] font-semibold mb-2">SEO Meta Description</label>
            <textarea id="meta_description" name="meta_description" rows="3"
                      class="w-full px-4 py-3 bg-[#121212] border border-gray-700 rounded-lg text-[#E0E0E0] focus:outline-none focus:border-[#00B4D8] resize-none"><?php echo e(old('meta_description')); ?></textarea>
            <?php $__errorArgs = ['meta_description'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?><p class="mt-2 text-sm text-red-500"><?php echo e($message); ?></p><?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
        </div>

        
        <div>
            <label for="published_at" class="block text-[#E0E0E0] font-semibold mb-2">Publish Date (leave empty for draft)</label>
            <input type="datetime-local" id="published_at" name="published_at" value="<?php echo e(old('published_at')); ?>"
                   class="w-full px-4 py-3 bg-[#121212] border border-gray-700 rounded-lg text-[#E0E0E0] focus:outline-none focus:border-[#00B4D8]">
            <?php $__errorArgs = ['published_at'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?><p class="mt-2 text-sm text-red-500"><?php echo e($message); ?></p><?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
        </div>

        
        <div class="flex space-x-4">
            <button type="submit" 
                    class="px-8 py-3 bg-[#00B4D8] text-white font-semibold rounded-lg hover:bg-[#00B4D8]/80 transition-colors">
                Create Post
            </button>
            <a href="<?php echo e(route('admin.posts.index')); ?>" 
               class="px-8 py-3 bg-gray-700 text-[#E0E0E0] font-semibold rounded-lg hover:bg-gray-600 transition-colors">
                Cancel
            </a>
        </div>
    </div>
</form>
<?php $__env->stopSection(); ?>


<?php echo $__env->make('layouts.admin', array_diff_key(get_defined_vars(), ['__data' => 1, '__path' => 1]))->render(); ?><?php /**PATH C:\xampp\htdocs\linkie-dev\resources\views/admin/posts/create.blade.php ENDPATH**/ ?>