<?php

use Illuminate\Support\Facades\Route;
use App\Http\Controllers\Admin\{
    DashboardController,
    PostController,
    ProductController,
    UserController,
    RoleController,
    ContactController,
    NavigationController,
    MediaController,
    SettingsController,
    SeoController,
    AppearanceController,
    LogController,
    ContentImportController
};

/*
|--------------------------------------------------------------------------
| Admin Panel Routes
|--------------------------------------------------------------------------
|
| All admin routes are protected by authentication and role-based access.
| Routes are organized by feature for better maintainability.
|
*/

Route::middleware(['auth'])->prefix('admin')->name('admin.')->group(function () {
    
    // Dashboard
    Route::get('/dashboard', [DashboardController::class, 'index'])->name('dashboard');
    
    // Content Management
    Route::prefix('content')->name('content.')->group(function () {
        Route::resource('posts', PostController::class);
        Route::post('posts/{post}/publish', [PostController::class, 'publish'])->name('posts.publish');
        Route::post('posts/{post}/unpublish', [PostController::class, 'unpublish'])->name('posts.unpublish');
    });
    
    // Products/Courses
    Route::resource('products', ProductController::class);
    Route::post('products/{product}/toggle-featured', [ProductController::class, 'toggleFeatured'])->name('products.toggle-featured');
    
    // Media Management
    Route::prefix('media')->name('media.')->group(function () {
        Route::get('/', [MediaController::class, 'index'])->name('index');
        Route::post('/upload', [MediaController::class, 'upload'])->name('upload');
        Route::delete('/{media}', [MediaController::class, 'destroy'])->name('destroy');
        Route::get('/browser', [MediaController::class, 'browser'])->name('browser'); // For rich editor
    });
    
    // SEO Management
    Route::prefix('seo')->name('seo.')->group(function () {
        Route::get('/', [SeoController::class, 'index'])->name('index');
        Route::post('/sitemap/generate', [SeoController::class, 'generateSitemap'])->name('sitemap.generate');
        Route::get('/analyze/{type}/{id}', [SeoController::class, 'analyze'])->name('analyze');
    });
    
    // User & Role Management
    Route::prefix('users')->name('users.')->group(function () {
        Route::resource('users', UserController::class);
        Route::resource('roles', RoleController::class);
        Route::post('users/{user}/assign-role', [UserController::class, 'assignRole'])->name('users.assign-role');
    });
    
    // Contact & Submissions
    Route::prefix('submissions')->name('submissions.')->group(function () {
        Route::get('/contacts', [ContactController::class, 'index'])->name('contacts');
        Route::get('/contacts/{contact}', [ContactController::class, 'show'])->name('contacts.show');
        Route::delete('/contacts/{contact}', [ContactController::class, 'destroy'])->name('contacts.destroy');
        Route::post('/contacts/export', [ContactController::class, 'export'])->name('contacts.export');
    });
    
    // Navigation Manager
    Route::prefix('navigation')->name('navigation.')->group(function () {
        Route::get('/', [NavigationController::class, 'index'])->name('index');
        Route::post('/store', [NavigationController::class, 'store'])->name('store');
        Route::post('/update-order', [NavigationController::class, 'updateOrder'])->name('update-order');
        Route::delete('/{menu}', [NavigationController::class, 'destroy'])->name('destroy');
    });
    
    // Appearance & Theme
    Route::prefix('appearance')->name('appearance.')->group(function () {
        Route::get('/', [AppearanceController::class, 'index'])->name('index');
        Route::post('/theme', [AppearanceController::class, 'updateTheme'])->name('theme');
        Route::post('/logo', [AppearanceController::class, 'uploadLogo'])->name('logo');
        Route::post('/favicon', [AppearanceController::class, 'uploadFavicon'])->name('favicon');
        Route::post('/header', [AppearanceController::class, 'updateHeader'])->name('header');
        Route::post('/footer', [AppearanceController::class, 'updateFooter'])->name('footer');
    });
    
    // Settings
    Route::prefix('settings')->name('settings.')->group(function () {
        Route::get('/', [SettingsController::class, 'index'])->name('index');
        Route::post('/general', [SettingsController::class, 'updateGeneral'])->name('general');
        Route::post('/mail', [SettingsController::class, 'updateMail'])->name('mail');
        Route::post('/analytics', [SettingsController::class, 'updateAnalytics'])->name('analytics');
    });
    
    // Logs & Analytics
    Route::prefix('logs')->name('logs.')->group(function () {
        Route::get('/', [LogController::class, 'index'])->name('index');
        Route::get('/analytics', [LogController::class, 'analytics'])->name('analytics');
        Route::get('/errors', [LogController::class, 'errors'])->name('errors');
    });
    
    // Content Import
    Route::prefix('import')->name('import.')->group(function () {
        Route::get('/', [ContentImportController::class, 'index'])->name('index');
        Route::post('/parse', [ContentImportController::class, 'parse'])->name('parse');
        Route::get('/preview', [ContentImportController::class, 'preview'])->name('preview');
        Route::post('/store', [ContentImportController::class, 'store'])->name('store');
    });
});

