@extends('layouts.main')

@section('title', $product->name . ' - Linkie.dev')

@section('content')
{{-- Single Product Page: Detailed view with dark background --}}
<section class="py-12 bg-[#121212]">
    {{-- Container: max-width 6xl (1152px), centered, responsive horizontal padding --}}
    <div class="max-w-6xl mx-auto px-4 sm:px-6 lg:px-8">
        {{-- Back Link: Navigation button with icon, accent color, hover effect, bottom margin --}}
        <a href="{{ route('products.index') }}" class="inline-flex items-center text-[#00B4D8] hover:text-[#00B4D8]/80 mb-8 transition-colors">
            {{-- Left Arrow Icon: Medium size (w-5 h-5), right margin --}}
            <svg class="w-5 h-5 mr-2" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M15 19l-7-7 7-7" />
            </svg>
            Back to Products
        </a>

        {{-- Product Layout: Responsive grid, 1 column mobile, 2 columns desktop (lg), large gap --}}
        <div class="grid grid-cols-1 lg:grid-cols-2 gap-12">
            {{-- Product Images Section: Left column on desktop --}}
            <div>
                {{-- Featured Image: Conditional rendering, large display, bottom margin, rounded corners, dark background --}}
                @if($product->featured_image)
                    {{-- Image Container: Bottom margin, rounded corners, overflow hidden, dark background fallback --}}
                    <div class="mb-6 rounded-lg overflow-hidden bg-gray-900">
                        {{-- Featured Image: Full width, auto height to maintain aspect ratio --}}
                        <img src="{{ Storage::url($product->featured_image) }}" 
                             alt="{{ $product->name }}"
                             class="w-full h-auto">
                    </div>
                @endif

                {{-- Additional Images: Conditional rendering if product has multiple images --}}
                @if($product->images && count($product->images) > 0)
                    {{-- Images Grid: 3 columns, gap spacing --}}
                    <div class="grid grid-cols-3 gap-4">
                        @foreach($product->images as $image)
                            {{-- Image Container: Rounded corners, overflow hidden, dark background --}}
                            <div class="rounded-lg overflow-hidden bg-gray-900">
                                {{-- Product Image: Full width, auto height --}}
                                <img src="{{ Storage::url($image) }}" 
                                     alt="{{ $product->name }}"
                                     class="w-full h-auto">
                            </div>
                        @endforeach
                    </div>
                @endif
            </div>

            {{-- Product Details Section: Right column on desktop --}}
            <div>
                {{-- Product Name: Responsive text size (4xl mobile, 5xl desktop), black weight, heading font, white text, bottom margin --}}
                <h1 class="text-4xl md:text-5xl font-black font-heading text-white mb-4">
                    {{ $product->name }}
                </h1>

                {{-- Price Display: Accent color, extra large text, bold, bottom margin --}}
                <div class="mb-6">
                    <span class="text-4xl font-bold text-[#00B4D8]">
                        {{ $product->formatted_price }}
                    </span>
                </div>

                {{-- Short Description: Conditional rendering, large text, muted color, bottom margin --}}
                @if($product->short_description)
                    <p class="text-lg text-[#E0E0E0]/80 mb-6">
                        {{ $product->short_description }}
                    </p>
                @endif

                {{-- Full Description: Conditional rendering, formatted text section --}}
                @if($product->description)
                    <div class="mb-8">
                        {{-- Description Title: Large text (2xl), bold, heading font, light text, bottom margin --}}
                        <h2 class="text-2xl font-bold font-heading text-[#E0E0E0] mb-4">Description</h2>
                        {{-- Description Content: Muted text (70% opacity), relaxed line height for readability --}}
                        <div class="text-[#E0E0E0]/70 leading-relaxed">
                            {!! nl2br(e($product->description)) !!}
                        </div>
                    </div>
                @endif

                {{-- CTA Buttons Section: Flex layout, responsive (column mobile, row tablet+), gap spacing --}}
                <div class="flex flex-col sm:flex-row gap-4">
                    {{-- ThemeForest Button: Conditional rendering if ThemeForest URL exists --}}
                    @if($product->themeforest_url)
                        {{-- External Link: Flex-1 for equal width, padding, accent background, white text, bold, rounded, hover effect, centered text, shadow --}}
                        <a href="{{ $product->themeforest_url }}" 
                           target="_blank"
                           rel="noopener noreferrer"
                           class="flex-1 px-8 py-4 bg-[#00B4D8] text-white font-bold rounded-lg hover:bg-[#00B4D8]/80 transition-colors text-center shadow-lg shadow-[#00B4D8]/30">
                            Buy on ThemeForest
                        </a>
                    @else
                        {{-- Buy Now Button: Placeholder button for future Stripe integration --}}
                        <button class="flex-1 px-8 py-4 bg-[#00B4D8] text-white font-bold rounded-lg hover:bg-[#00B4D8]/80 transition-colors shadow-lg shadow-[#00B4D8]/30">
                            Buy Now
                        </button>
                    @endif
                </div>
            </div>
        </div>
    </div>
</section>
@endsection

