@extends('layouts.main')

@section('title', 'Contact - Linkie.dev')

@section('content')
{{-- Contact Page: Form with dark styling --}}
<section class="py-20 bg-[#121212]">
    <div class="max-w-2xl mx-auto px-4 sm:px-6 lg:px-8">
        {{-- Page Header: Title --}}
        <div class="text-center mb-12">
            <h1 class="text-5xl font-black font-heading text-white mb-4">
                Get in <span class="text-[#00B4D8]">Touch</span>
            </h1>
            <p class="text-xl text-[#E0E0E0]/70">
                Have a question or want to collaborate? Send us a message!
            </p>
        </div>

        {{-- Contact Form: Dark theme, accent color buttons --}}
        <form action="{{ route('contact.store') }}" method="POST" class="bg-[#1a1a1a] rounded-lg border border-gray-800 p-8">
            @csrf

            {{-- Name Field: Full width --}}
            <div class="mb-6">
                <label for="name" class="block text-[#E0E0E0] font-semibold mb-2">
                    Name <span class="text-red-500">*</span>
                </label>
                <input type="text" 
                       id="name" 
                       name="name" 
                       value="{{ old('name') }}"
                       required
                       class="w-full px-4 py-3 bg-[#121212] border border-gray-700 rounded-lg text-[#E0E0E0] focus:outline-none focus:border-[#00B4D8] transition-colors"
                       placeholder="Your name">
                @error('name')
                    <p class="mt-2 text-sm text-red-500">{{ $message }}</p>
                @enderror
            </div>

            {{-- Email Field: Full width --}}
            <div class="mb-6">
                <label for="email" class="block text-[#E0E0E0] font-semibold mb-2">
                    Email <span class="text-red-500">*</span>
                </label>
                <input type="email" 
                       id="email" 
                       name="email" 
                       value="{{ old('email') }}"
                       required
                       class="w-full px-4 py-3 bg-[#121212] border border-gray-700 rounded-lg text-[#E0E0E0] focus:outline-none focus:border-[#00B4D8] transition-colors"
                       placeholder="your.email@example.com">
                @error('email')
                    <p class="mt-2 text-sm text-red-500">{{ $message }}</p>
                @enderror
            </div>

            {{-- Subject Field: Full width --}}
            <div class="mb-6">
                <label for="subject" class="block text-[#E0E0E0] font-semibold mb-2">
                    Subject
                </label>
                <input type="text" 
                       id="subject" 
                       name="subject" 
                       value="{{ old('subject') }}"
                       class="w-full px-4 py-3 bg-[#121212] border border-gray-700 rounded-lg text-[#E0E0E0] focus:outline-none focus:border-[#00B4D8] transition-colors"
                       placeholder="What's this about?">
                @error('subject')
                    <p class="mt-2 text-sm text-red-500">{{ $message }}</p>
                @enderror
            </div>

            {{-- Message Field: Textarea, full width --}}
            <div class="mb-6">
                <label for="message" class="block text-[#E0E0E0] font-semibold mb-2">
                    Message <span class="text-red-500">*</span>
                </label>
                <textarea id="message" 
                          name="message" 
                          rows="6"
                          required
                          class="w-full px-4 py-3 bg-[#121212] border border-gray-700 rounded-lg text-[#E0E0E0] focus:outline-none focus:border-[#00B4D8] transition-colors resize-none"
                          placeholder="Your message here...">{{ old('message') }}</textarea>
                @error('message')
                    <p class="mt-2 text-sm text-red-500">{{ $message }}</p>
                @enderror
            </div>

            {{-- Submit Button: Accent color, full width on mobile --}}
            <button type="submit" 
                    class="w-full px-8 py-4 bg-[#00B4D8] text-white font-bold rounded-lg hover:bg-[#00B4D8]/80 transition-colors shadow-lg shadow-[#00B4D8]/30">
                Send Message
            </button>
        </form>

        {{-- Social Links: Below form --}}
        <div class="mt-12 text-center">
            <p class="text-[#E0E0E0]/70 mb-4">Or connect with us on social media:</p>
            <div class="flex justify-center space-x-6">
                <a href="#" class="text-[#E0E0E0]/70 hover:text-[#00B4D8] transition-colors" aria-label="Twitter">
                    <svg class="w-6 h-6" fill="currentColor" viewBox="0 0 24 24">
                        <path d="M8.29 20.251c7.547 0 11.675-6.253 11.675-11.675 0-.178 0-.355-.012-.53A8.348 8.348 0 0022 5.92a8.19 8.19 0 01-2.357.646 4.118 4.118 0 001.804-2.27 8.224 8.224 0 01-2.605.996 4.107 4.107 0 00-6.993 3.743 11.65 11.65 0 01-8.457-4.287 4.106 4.106 0 001.27 5.477A4.072 4.072 0 012.8 9.713v.052a4.105 4.105 0 003.292 4.022 4.095 4.095 0 01-1.853.07 4.108 4.108 0 003.834 2.85A8.233 8.233 0 012 18.407a11.616 11.616 0 006.29 1.84"/>
                    </svg>
                </a>
                <a href="#" class="text-[#E0E0E0]/70 hover:text-[#00B4D8] transition-colors" aria-label="GitHub">
                    <svg class="w-6 h-6" fill="currentColor" viewBox="0 0 24 24">
                        <path fill-rule="evenodd" d="M12 2C6.477 2 2 6.484 2 12.017c0 4.425 2.865 8.18 6.839 9.504.5.092.682-.217.682-.483 0-.237-.008-.868-.013-1.703-2.782.605-3.369-1.343-3.369-1.343-.454-1.158-1.11-1.466-1.11-1.466-.908-.62.069-.608.069-.608 1.003.07 1.531 1.032 1.531 1.032.892 1.53 2.341 1.088 2.91.832.092-.647.35-1.088.636-1.338-2.22-.253-4.555-1.113-4.555-4.951 0-1.093.39-1.988 1.029-2.688-.103-.253-.446-1.272.098-2.65 0 0 .84-.27 2.75 1.026A9.564 9.564 0 0112 6.844c.85.004 1.705.115 2.504.337 1.909-1.296 2.747-1.027 2.747-1.027.546 1.379.202 2.398.1 2.651.64.7 1.028 1.595 1.028 2.688 0 3.848-2.339 4.695-4.566 4.943.359.309.678.92.678 1.855 0 1.338-.012 2.419-.012 2.747 0 .268.18.58.688.482C19.138 20.197 22 16.425 22 12.017 22 6.484 17.522 2 12 2z" clip-rule="evenodd"/>
                    </svg>
                </a>
                <a href="#" class="text-[#E0E0E0]/70 hover:text-[#00B4D8] transition-colors" aria-label="LinkedIn">
                    <svg class="w-6 h-6" fill="currentColor" viewBox="0 0 24 24">
                        <path d="M19 0h-14c-2.761 0-5 2.239-5 5v14c0 2.761 2.239 5 5 5h14c2.762 0 5-2.239 5-5v-14c0-2.761-2.238-5-5-5zm-11 19h-3v-11h3v11zm-1.5-12.268c-.966 0-1.75-.79-1.75-1.764s.784-1.764 1.75-1.764 1.75.79 1.75 1.764-.783 1.764-1.75 1.764zm13.5 12.268h-3v-5.604c0-3.368-4-3.113-4 0v5.604h-3v-11h3v1.765c1.396-2.586 7-2.777 7 2.476v6.759z"/>
                    </svg>
                </a>
            </div>
        </div>
    </div>
</section>
@endsection

