{{-- Rating Stars Component: Display star rating with review count --}}
@props(['rating' => 4.8, 'reviewCount' => 2100, 'size' => 'md'])

@php
    $fullStars = floor($rating);
    $hasHalfStar = ($rating - $fullStars) >= 0.5;
    $emptyStars = 5 - $fullStars - ($hasHalfStar ? 1 : 0);
    $sizeClasses = [
        'sm' => 'w-4 h-4',
        'md' => 'w-5 h-5',
        'lg' => 'w-6 h-6'
    ];
    $iconSize = $sizeClasses[$size] ?? $sizeClasses['md'];
@endphp

<div class="flex items-center space-x-2">
    {{-- Star Rating: Flex container with stars --}}
    <div class="flex items-center space-x-1">
        {{-- Full Stars: Yellow/gold color for filled stars --}}
        @for($i = 0; $i < $fullStars; $i++)
            <svg class="{{ $iconSize }} text-yellow-400 fill-current" fill="currentColor" viewBox="0 0 20 20">
                <path d="M9.049 2.927c.3-.921 1.603-.921 1.902 0l1.07 3.292a1 1 0 00.95.69h3.462c.969 0 1.371 1.24.588 1.81l-2.8 2.034a1 1 0 00-.364 1.118l1.07 3.292c.3.921-.755 1.688-1.54 1.118l-2.8-2.034a1 1 0 00-1.175 0l-2.8 2.034c-.784.57-1.838-.197-1.539-1.118l1.07-3.292a1 1 0 00-.364-1.118L2.98 8.72c-.783-.57-.38-1.81.588-1.81h3.461a1 1 0 00.951-.69l1.07-3.292z" />
            </svg>
        @endfor
        
        {{-- Half Star: If rating has 0.5 --}}
        @if($hasHalfStar)
            <div class="relative {{ $iconSize }}">
                {{-- Background empty star --}}
                <svg class="absolute text-gray-600 fill-current" fill="currentColor" viewBox="0 0 20 20">
                    <path d="M9.049 2.927c.3-.921 1.603-.921 1.902 0l1.07 3.292a1 1 0 00.95.69h3.462c.969 0 1.371 1.24.588 1.81l-2.8 2.034a1 1 0 00-.364 1.118l1.07 3.292c.3.921-.755 1.688-1.54 1.118l-2.8-2.034a1 1 0 00-1.175 0l-2.8 2.034c-.784.57-1.838-.197-1.539-1.118l1.07-3.292a1 1 0 00-.364-1.118L2.98 8.72c-.783-.57-.38-1.81.588-1.81h3.461a1 1 0 00.951-.69l1.07-3.292z" />
                </svg>
                {{-- Foreground half-filled star --}}
                <svg class="absolute text-yellow-400 fill-current" fill="currentColor" viewBox="0 0 20 20" style="clip-path: inset(0 50% 0 0);">
                    <path d="M9.049 2.927c.3-.921 1.603-.921 1.902 0l1.07 3.292a1 1 0 00.95.69h3.462c.969 0 1.371 1.24.588 1.81l-2.8 2.034a1 1 0 00-.364 1.118l1.07 3.292c.3.921-.755 1.688-1.54 1.118l-2.8-2.034a1 1 0 00-1.175 0l-2.8 2.034c-.784.57-1.838-.197-1.539-1.118l1.07-3.292a1 1 0 00-.364-1.118L2.98 8.72c-.783-.57-.38-1.81.588-1.81h3.461a1 1 0 00.951-.69l1.07-3.292z" />
                </svg>
            </div>
        @endif
        
        {{-- Empty Stars: Gray color for unfilled stars --}}
        @for($i = 0; $i < $emptyStars; $i++)
            <svg class="{{ $iconSize }} text-gray-600 fill-current" fill="currentColor" viewBox="0 0 20 20">
                <path d="M9.049 2.927c.3-.921 1.603-.921 1.902 0l1.07 3.292a1 1 0 00.95.69h3.462c.969 0 1.371 1.24.588 1.81l-2.8 2.034a1 1 0 00-.364 1.118l1.07 3.292c.3.921-.755 1.688-1.54 1.118l-2.8-2.034a1 1 0 00-1.175 0l-2.8 2.034c-.784.57-1.838-.197-1.539-1.118l1.07-3.292a1 1 0 00-.364-1.118L2.98 8.72c-.783-.57-.38-1.81.588-1.81h3.461a1 1 0 00.951-.69l1.07-3.292z" />
            </svg>
        @endfor
    </div>
    
    {{-- Rating Text: Display rating number and review count --}}
    <span class="text-[#E0E0E0] font-semibold">{{ number_format($rating, 1) }}/5</span>
    @if($reviewCount > 0)
        <span class="text-[#E0E0E0]/70 text-sm">({{ number_format($reviewCount) }}+ reviews)</span>
    @endif
</div>

