{{-- Product Card Component - Reusable dark card with price and CTA button --}}
{{-- Link wrapper: Block display, group for hover effects on child elements --}}
<a href="{{ route('products.show', $product->slug) }}" class="block group">
    {{-- Card Container: Dark card background (#1a1a1a), rounded corners, overflow hidden for image, border with hover accent color, smooth transitions --}}
    <div class="bg-[#1a1a1a] rounded-lg overflow-hidden border border-gray-800 hover:border-[#00B4D8] transition-all duration-300 hover:shadow-lg hover:shadow-[#00B4D8]/20">
        {{-- Featured Image Section: Conditional rendering if product has image --}}
        @if($product->featured_image)
            {{-- Image Container: 16:9 aspect ratio, full width, overflow hidden, dark background fallback --}}
            <div class="aspect-video w-full overflow-hidden bg-gray-900">
                {{-- Product Image: Full width/height, object-cover for proper scaling, scale on hover (group-hover), smooth transition --}}
                <img src="{{ Storage::url($product->featured_image) }}" 
                     alt="{{ $product->name }}"
                     class="w-full h-full object-cover group-hover:scale-105 transition-transform duration-300">
            </div>
        @else
            {{-- Placeholder: Gradient background from dark blue to accent cyan, centered content --}}
            <div class="aspect-video w-full bg-gradient-to-br from-[#1E3A8A] to-[#00B4D8] flex items-center justify-center">
                <span class="text-4xl font-bold text-white/50">🛠️</span>
            </div>
        @endif

        {{-- Card Content Section: Padding (p-6 = 1.5rem) for spacing --}}
        <div class="p-6">
            {{-- Product Name: Large text (xl), bold weight, heading font, light text color, hover accent color, bottom margin, line clamp to 2 lines --}}
            <h3 class="text-xl font-bold font-heading text-[#E0E0E0] group-hover:text-[#00B4D8] transition-colors mb-2 line-clamp-2">
                {{ $product->name }}
            </h3>

            {{-- Short Description: Conditional rendering, muted text (70% opacity), small text, bottom margin, line clamp to 2 lines --}}
            @if($product->short_description)
                <p class="text-[#E0E0E0]/70 text-sm mb-4 line-clamp-2">
                    {{ $product->short_description }}
                </p>
            @endif

            {{-- Price and CTA Section: Flexbox layout, space between items, top margin --}}
            <div class="flex items-center justify-between mt-4">
                {{-- Price Display: Extra large text (2xl), bold, accent color --}}
                <span class="text-2xl font-bold text-[#00B4D8]">
                    {{ $product->formatted_price }}
                </span>
                {{-- CTA Button: Padding, accent background, white text, small text, semibold, rounded corners, hover opacity change --}}
                <span class="px-4 py-2 bg-[#00B4D8] text-white text-sm font-semibold rounded-lg group-hover:bg-[#00B4D8]/80 transition-colors">
                    View Details
                </span>
            </div>
        </div>
    </div>
</a>

