{{-- Navigation Bar Component - Dark theme with responsive design --}}
<nav class="bg-[#121212] border-b border-gray-800 sticky top-0 z-40">
    {{-- Container: max-width, centered, padding for mobile/desktop --}}
    <div class="max-w-7xl mx-auto px-4 sm:px-6 lg:px-8">
        <div class="flex justify-between items-center h-16">
            {{-- Logo/Brand: Left side, bold typography --}}
            <div class="flex-shrink-0">
                <a href="{{ route('home') }}" class="text-2xl font-bold font-heading text-[#00B4D8] hover:text-[#00B4D8]/80 transition-colors">
                    Linkie.dev
                </a>
            </div>

            {{-- Desktop Navigation Links: Hidden on mobile, visible on md+ --}}
            <div class="hidden md:flex md:space-x-8">
                <a href="{{ route('home') }}" class="text-[#E0E0E0] hover:text-[#00B4D8] px-3 py-2 text-sm font-medium transition-colors">
                    Home
                </a>
                <a href="{{ route('blog.index') }}" class="text-[#E0E0E0] hover:text-[#00B4D8] px-3 py-2 text-sm font-medium transition-colors">
                    Blog
                </a>
                <a href="{{ route('products.index') }}" class="text-[#E0E0E0] hover:text-[#00B4D8] px-3 py-2 text-sm font-medium transition-colors">
                    Products
                </a>
                <a href="{{ route('about.index') }}" class="text-[#E0E0E0] hover:text-[#00B4D8] px-3 py-2 text-sm font-medium transition-colors">
                    About
                </a>
                <a href="{{ route('contact.index') }}" class="text-[#E0E0E0] hover:text-[#00B4D8] px-3 py-2 text-sm font-medium transition-colors">
                    Contact
                </a>
            </div>

            {{-- Admin/Login Links: Right side --}}
            <div class="hidden md:flex md:items-center md:space-x-4">
                @auth
                    <a href="{{ route('admin.dashboard') }}" class="text-[#E0E0E0] hover:text-[#00B4D8] px-3 py-2 text-sm font-medium transition-colors">
                        Admin
                    </a>
                    <form method="POST" action="{{ route('logout') }}" class="inline">
                        @csrf
                        <button type="submit" class="text-[#E0E0E0] hover:text-[#00B4D8] px-3 py-2 text-sm font-medium transition-colors">
                            Logout
                        </button>
                    </form>
                @else
                    <a href="{{ route('login') }}" class="text-[#E0E0E0] hover:text-[#00B4D8] px-3 py-2 text-sm font-medium transition-colors">
                        Login
                    </a>
                @endauth
            </div>

            {{-- Mobile Menu Button: Visible on mobile, hidden on md+ --}}
            <div class="md:hidden">
                <button type="button" id="mobile-menu-button" class="text-[#E0E0E0] hover:text-[#00B4D8] focus:outline-none focus:text-[#00B4D8]">
                    <svg class="h-6 w-6" fill="none" viewBox="0 0 24 24" stroke="currentColor">
                        <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M4 6h16M4 12h16M4 18h16" />
                    </svg>
                </button>
            </div>
        </div>
    </div>

    {{-- Mobile Menu: Hidden by default, shown when button clicked --}}
    <div id="mobile-menu" class="hidden md:hidden border-t border-gray-800">
        <div class="px-2 pt-2 pb-3 space-y-1">
            <a href="{{ route('home') }}" class="block text-[#E0E0E0] hover:text-[#00B4D8] px-3 py-2 text-base font-medium transition-colors">
                Home
            </a>
            <a href="{{ route('blog.index') }}" class="block text-[#E0E0E0] hover:text-[#00B4D8] px-3 py-2 text-base font-medium transition-colors">
                Blog
            </a>
            <a href="{{ route('products.index') }}" class="block text-[#E0E0E0] hover:text-[#00B4D8] px-3 py-2 text-base font-medium transition-colors">
                Products
            </a>
            <a href="{{ route('about.index') }}" class="block text-[#E0E0E0] hover:text-[#00B4D8] px-3 py-2 text-base font-medium transition-colors">
                About
            </a>
            <a href="{{ route('contact.index') }}" class="block text-[#E0E0E0] hover:text-[#00B4D8] px-3 py-2 text-base font-medium transition-colors">
                Contact
            </a>
            @auth
                <a href="{{ route('admin.dashboard') }}" class="block text-[#E0E0E0] hover:text-[#00B4D8] px-3 py-2 text-base font-medium transition-colors">
                    Admin
                </a>
                <form method="POST" action="{{ route('logout') }}" class="inline">
                    @csrf
                    <button type="submit" class="block w-full text-left text-[#E0E0E0] hover:text-[#00B4D8] px-3 py-2 text-base font-medium transition-colors">
                        Logout
                    </button>
                </form>
            @else
                <a href="{{ route('login') }}" class="block text-[#E0E0E0] hover:text-[#00B4D8] px-3 py-2 text-base font-medium transition-colors">
                    Login
                </a>
            @endauth
        </div>
    </div>
</nav>

{{-- JavaScript for mobile menu toggle --}}
<script>
    document.getElementById('mobile-menu-button')?.addEventListener('click', function() {
        document.getElementById('mobile-menu')?.classList.toggle('hidden');
    });
</script>

