{{-- CTA Block Component: Reusable call-to-action block for affiliate links --}}
@props(['link', 'text' => null, 'title' => ''])

@if(!empty($link) && filter_var($link, FILTER_VALIDATE_URL))
    {{-- CTA Container: Dark card background, cyan border, centered content, shadow --}}
    {{-- Responsive: Full width on mobile, compact in sidebar on desktop --}}
    <div class="my-10 xl:my-0 xl:mb-6 p-6 xl:p-6 bg-[#1A1A1A] border border-cyan-500/20 rounded-xl text-center shadow-xl">
        {{-- CTA Heading: Large, bold, cyan accent color, rocket emoji --}}
        <h3 class="text-xl xl:text-2xl font-bold text-cyan-300 mb-3 xl:mb-4">
            Try {{ $title }} Today 🚀
        </h3>
        
        {{-- CTA Description: Conditional text or default message, muted text color --}}
        @if($text)
            <p class="text-[#E0E0E0]/80 mb-4 xl:mb-6 text-sm xl:text-lg">{{ $text }}</p>
        @else
            <p class="text-[#E0E0E0]/80 mb-4 xl:mb-6 text-sm xl:text-lg">
                Create AI videos faster and easier without recording yourself.
            </p>
        @endif

        {{-- CTA Button: Gradient background, bold text, hover effects, shadow --}}
        <a 
            href="{{ $link }}" 
            target="_blank"
            rel="nofollow"
            class="inline-block w-full xl:w-auto px-6 xl:px-8 py-3 xl:py-4 bg-gradient-to-r from-cyan-500 to-blue-600 
                   text-white font-extrabold text-base xl:text-lg rounded-xl hover:opacity-90 
                   transition-all transform hover:scale-105 shadow-lg hover:shadow-cyan-500/50">
            👉 Get {{ $title }}
        </a>

        {{-- Trust Badge: Security and guarantee text, small, muted --}}
        <p class="text-xs text-[#E0E0E0]/50 mt-4">
            ✓ Secure Checkout • ✓ Money-Back Guarantee
        </p>
    </div>
@endif

