{{-- Affiliate Product Card Component: Sidebar card for affiliate products --}}
@props(['post'])

@php
    // Get affiliate link from database first, then extract from content as fallback
    $affiliateLink = $post->affiliate_link ?? '';
    $content = html_entity_decode($post->content, ENT_QUOTES | ENT_HTML5, 'UTF-8');
    
    // If not in database, try to extract from content
    if (empty($affiliateLink)) {
        if (preg_match('/href=["\']([^"\']+)["\'].*target=["\']_blank["\']/', $content, $matches)) {
            $affiliateLink = $matches[1];
        }
    }
    
    // Extract pros/features for key benefits
    $pros = [];
    if (preg_match('/<h2>Pros<\/h2><ul>(.*?)<\/ul>/s', $content, $matches)) {
        preg_match_all('/<li>(.*?)<\/li>/', $matches[1], $proMatches);
        $pros = array_slice(array_map('strip_tags', $proMatches[1]), 0, 3); // Take first 3
    }
    
    // If no pros, try features
    if (empty($pros) && preg_match('/<h2>Features<\/h2><ul>(.*?)<\/ul>/s', $content, $matches)) {
        preg_match_all('/<li>(.*?)<\/li>/', $matches[1], $featureMatches);
        $pros = array_slice(array_map('strip_tags', $featureMatches[1]), 0, 3);
    }
    
    // Get featured image
    $imageUrl = $post->featured_image ? Storage::url($post->featured_image) : null;
@endphp

@if($affiliateLink || $imageUrl || !empty($pros))
    {{-- Affiliate Card Container: Sticky sidebar card, dark background, rounded, shadow --}}
    <div class="sticky top-24 space-y-4 bg-[#1A1A1A] p-6 rounded-xl border border-gray-800 shadow-xl">
        {{-- Product Image: Featured image with rounded corners --}}
        @if($imageUrl)
            <div class="mb-4">
                <img 
                    src="{{ $imageUrl }}" 
                    alt="{{ $post->title }}"
                    class="w-full h-auto rounded-lg object-cover">
            </div>
        @endif
        
        {{-- Product Title: Bold, white text, truncated --}}
        <h3 class="text-xl font-bold text-white line-clamp-2">{{ $post->title }}</h3>
        
        {{-- Rating Stars: Component for product rating --}}
        <x-rating-stars :rating="4.8" :reviewCount="2100" size="sm" />
        
        {{-- Short Summary: Excerpt or first part of content --}}
        @if($post->excerpt)
            <p class="text-[#E0E0E0]/80 text-sm leading-relaxed line-clamp-3">{{ $post->excerpt }}</p>
        @endif
        
        {{-- Key Benefits: List of top 3 pros/features --}}
        @if(!empty($pros))
            <div class="pt-4 border-t border-gray-800">
                <h4 class="text-sm font-semibold text-cyan-400 mb-3">Key Benefits:</h4>
                <ul class="space-y-2">
                    @foreach($pros as $pro)
                        <li class="flex items-start text-sm text-[#E0E0E0]/80">
                            {{-- Check Icon: Green checkmark for benefits --}}
                            <svg class="w-5 h-5 text-green-400 mr-2 flex-shrink-0 mt-0.5" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                                <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M5 13l4 4L19 7" />
                            </svg>
                            <span>{{ $pro }}</span>
                        </li>
                    @endforeach
                </ul>
            </div>
        @endif
        
        {{-- Trust Badge: Security/guarantee text --}}
        <p class="text-xs text-center text-[#E0E0E0]/50 mt-4">
            ✓ Secure Checkout • ✓ Money-Back Guarantee
        </p>
    </div>
@endif

