@extends('layouts.main')

@section('title', 'Blog - Linkie.dev')

@section('content')
{{-- Blog List Page: Header with filters --}}
<section class="py-12 bg-[#121212]">
    <div class="max-w-7xl mx-auto px-4 sm:px-6 lg:px-8">
        {{-- Page Header: Title and description --}}
        <div class="text-center mb-12">
            <h1 class="text-5xl font-black font-heading text-white mb-4">
                Technical <span class="text-[#00B4D8]">Blog</span>
            </h1>
            <p class="text-xl text-[#E0E0E0]/70 max-w-2xl mx-auto">
                Explore our latest tutorials, reviews, and technical insights
            </p>
        </div>

        {{-- Category Filters: Flex layout, responsive, centered --}}
        @if($categories->count() > 0)
            {{-- Filter Container: Flexbox with wrap, gap spacing, centered, bottom margin --}}
            <div class="flex flex-wrap gap-3 justify-center mb-12">
                {{-- All Categories Button: Active state when no category selected, accent border and background --}}
                <a href="{{ route('blog.index') }}" 
                   class="px-6 py-2 rounded-full border-2 {{ !request('category') ? 'border-[#00B4D8] bg-[#00B4D8]/10 text-[#00B4D8]' : 'border-gray-700 text-[#E0E0E0]/70 hover:border-[#00B4D8]' }} transition-colors font-semibold">
                    All
                </a>
                
                {{-- Category Buttons: Loop through categories, active state styling, hover effects --}}
                @foreach($categories as $category)
                    <a href="{{ route('blog.index', ['category' => $category]) }}" 
                       class="px-6 py-2 rounded-full border-2 {{ request('category') == $category ? 'border-[#00B4D8] bg-[#00B4D8]/10 text-[#00B4D8]' : 'border-gray-700 text-[#E0E0E0]/70 hover:border-[#00B4D8]' }} transition-colors font-semibold">
                        {{ $category }}
                    </a>
                @endforeach
            </div>
        @endif

        {{-- Posts Grid: Responsive grid layout --}}
        @if($posts->count() > 0)
            <div class="grid grid-cols-1 md:grid-cols-2 lg:grid-cols-3 gap-8 mb-12">
                @foreach($posts as $post)
                    <x-blog-card :post="$post" />
                @endforeach
            </div>

            {{-- Pagination: Centered, dark theme --}}
            <div class="flex justify-center">
                {{ $posts->links() }}
            </div>
        @else
            {{-- Empty State: Centered message --}}
            <div class="text-center py-16">
                <p class="text-[#E0E0E0]/50 text-xl mb-4">No blog posts found.</p>
                @if(request('category'))
                    <a href="{{ route('blog.index') }}" class="text-[#00B4D8] hover:text-[#00B4D8]/80 font-semibold">
                        View all posts →
                    </a>
                @endif
            </div>
        @endif
    </div>
</section>
@endsection

