@extends('admin.layouts.app')

@section('title', 'Contact Submission Details')

@section('page-header')
<div class="flex items-center justify-between">
    <div>
        <h1 class="text-3xl font-bold text-gray-900 dark:text-white">Contact Submission</h1>
        <p class="mt-1 text-sm text-gray-500 dark:text-gray-400">View contact form submission details</p>
    </div>
    <a href="{{ route('admin.submissions.contacts') }}" 
       class="inline-flex items-center px-4 py-2 bg-gray-600 hover:bg-gray-700 text-white font-medium rounded-lg transition-colors">
        ← Back to Submissions
    </a>
</div>
@endsection

@section('content')
<div class="grid grid-cols-1 lg:grid-cols-3 gap-6">
    {{-- Main Content --}}
    <div class="lg:col-span-2 space-y-6">
        {{-- Message Card --}}
        <div class="bg-white dark:bg-gray-800 rounded-lg shadow-sm border border-gray-200 dark:border-gray-700 p-6">
            <h2 class="text-xl font-semibold text-gray-900 dark:text-white mb-4">Message</h2>
            <div class="prose dark:prose-invert max-w-none">
                <p class="text-gray-700 dark:text-gray-300 whitespace-pre-wrap">{{ $contact->message }}</p>
            </div>
        </div>
    </div>
    
    {{-- Sidebar --}}
    <div class="space-y-6">
        {{-- Contact Information --}}
        <div class="bg-white dark:bg-gray-800 rounded-lg shadow-sm border border-gray-200 dark:border-gray-700 p-6">
            <h3 class="text-lg font-semibold text-gray-900 dark:text-white mb-4">Contact Information</h3>
            <dl class="space-y-3">
                <div>
                    <dt class="text-sm font-medium text-gray-500 dark:text-gray-400">Name</dt>
                    <dd class="mt-1 text-sm text-gray-900 dark:text-white">{{ $contact->name }}</dd>
                </div>
                <div>
                    <dt class="text-sm font-medium text-gray-500 dark:text-gray-400">Email</dt>
                    <dd class="mt-1 text-sm text-gray-900 dark:text-white">
                        <a href="mailto:{{ $contact->email }}" class="text-cyan-600 dark:text-cyan-400 hover:underline">
                            {{ $contact->email }}
                        </a>
                    </dd>
                </div>
                @if($contact->subject)
                <div>
                    <dt class="text-sm font-medium text-gray-500 dark:text-gray-400">Subject</dt>
                    <dd class="mt-1 text-sm text-gray-900 dark:text-white">{{ $contact->subject }}</dd>
                </div>
                @endif
                <div>
                    <dt class="text-sm font-medium text-gray-500 dark:text-gray-400">Submitted</dt>
                    <dd class="mt-1 text-sm text-gray-900 dark:text-white">{{ $contact->created_at->format('F d, Y \a\t g:i A') }}</dd>
                </div>
                <div>
                    <dt class="text-sm font-medium text-gray-500 dark:text-gray-400">Status</dt>
                    <dd class="mt-1">
                        @if($contact->read_at)
                            <span class="px-2 py-1 text-xs font-semibold rounded-full bg-green-100 dark:bg-green-900/30 text-green-800 dark:text-green-400">
                                Read on {{ $contact->read_at->format('M d, Y') }}
                            </span>
                        @else
                            <span class="px-2 py-1 text-xs font-semibold rounded-full bg-blue-100 dark:bg-blue-900/30 text-blue-800 dark:text-blue-400">
                                New
                            </span>
                        @endif
                    </dd>
                </div>
            </dl>
        </div>
        
        {{-- Actions --}}
        <div class="bg-white dark:bg-gray-800 rounded-lg shadow-sm border border-gray-200 dark:border-gray-700 p-6">
            <h3 class="text-lg font-semibold text-gray-900 dark:text-white mb-4">Actions</h3>
            <div class="space-y-3">
                <a href="mailto:{{ $contact->email }}?subject=Re: {{ $contact->subject ?? 'Your inquiry' }}" 
                   class="block w-full px-4 py-2 bg-cyan-600 hover:bg-cyan-700 text-white text-center font-medium rounded-lg transition-colors">
                    Reply via Email
                </a>
                <form action="{{ route('admin.submissions.contacts.destroy', $contact) }}" 
                      method="POST" 
                      onsubmit="return confirm('Delete this submission?');">
                    @csrf
                    @method('DELETE')
                    <button type="submit" 
                            class="block w-full px-4 py-2 bg-red-600 hover:bg-red-700 text-white font-medium rounded-lg transition-colors">
                        Delete Submission
                    </button>
                </form>
            </div>
        </div>
    </div>
</div>
@endsection

