@extends('admin.layouts.app')

@section('title', 'SEO Management')

@section('page-header')
<div class="flex items-center justify-between">
    <div>
        <h1 class="text-3xl font-bold text-gray-900 dark:text-white">SEO Management</h1>
        <p class="mt-1 text-sm text-gray-500 dark:text-gray-400">Manage SEO settings, meta tags, and sitemap</p>
    </div>
    <form action="{{ route('admin.seo.sitemap.generate') }}" method="POST" class="inline">
        @csrf
        <button type="submit" 
                class="inline-flex items-center px-4 py-2 bg-cyan-600 hover:bg-cyan-700 text-white font-medium rounded-lg transition-colors">
            <svg class="w-5 h-5 mr-2" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M4 16v1a3 3 0 003 3h10a3 3 0 003-3v-1m-4-4l-4 4m0 0l-4-4m4 4V4" />
            </svg>
            Generate Sitemap
        </button>
    </form>
</div>
@endsection

@section('content')
<div class="grid grid-cols-1 lg:grid-cols-2 gap-6">
    {{-- SEO Settings --}}
    <div class="bg-white dark:bg-gray-800 rounded-lg shadow-sm border border-gray-200 dark:border-gray-700 p-6">
        <h2 class="text-xl font-semibold text-gray-900 dark:text-white mb-4">Global SEO Settings</h2>
        <form class="space-y-4">
            <div>
                <label class="block text-sm font-medium text-gray-700 dark:text-gray-300 mb-2">
                    Default Meta Title
                </label>
                <input type="text" 
                       class="w-full px-4 py-2 bg-white dark:bg-gray-700 border border-gray-300 dark:border-gray-600 rounded-lg text-gray-900 dark:text-white focus:ring-2 focus:ring-cyan-500 focus:border-transparent"
                       placeholder="Site Name - Tagline">
            </div>
            <div>
                <label class="block text-sm font-medium text-gray-700 dark:text-gray-300 mb-2">
                    Default Meta Description
                </label>
                <textarea rows="3"
                          class="w-full px-4 py-2 bg-white dark:bg-gray-700 border border-gray-300 dark:border-gray-600 rounded-lg text-gray-900 dark:text-white focus:ring-2 focus:ring-cyan-500 focus:border-transparent resize-none"
                          placeholder="Default description for pages without specific meta description"></textarea>
            </div>
            <div>
                <label class="block text-sm font-medium text-gray-700 dark:text-gray-300 mb-2">
                    Default OG Image URL
                </label>
                <input type="url" 
                       class="w-full px-4 py-2 bg-white dark:bg-gray-700 border border-gray-300 dark:border-gray-600 rounded-lg text-gray-900 dark:text-white focus:ring-2 focus:ring-cyan-500 focus:border-transparent"
                       placeholder="https://example.com/og-image.jpg">
            </div>
            <button type="submit" class="w-full px-4 py-2 bg-cyan-600 hover:bg-cyan-700 text-white font-medium rounded-lg transition-colors">
                Save Settings
            </button>
        </form>
    </div>
    
    {{-- Sitemap Status --}}
    <div class="bg-white dark:bg-gray-800 rounded-lg shadow-sm border border-gray-200 dark:border-gray-700 p-6">
        <h2 class="text-xl font-semibold text-gray-900 dark:text-white mb-4">Sitemap</h2>
        <div class="space-y-4">
            <div class="flex items-center justify-between p-4 bg-gray-50 dark:bg-gray-700 rounded-lg">
                <div>
                    <p class="text-sm font-medium text-gray-900 dark:text-white">sitemap.xml</p>
                    <p class="text-xs text-gray-500 dark:text-gray-400 mt-1">Last generated: {{ now()->format('M d, Y H:i') }}</p>
                </div>
                <a href="{{ url('/sitemap.xml') }}" 
                   target="_blank"
                   class="text-cyan-600 dark:text-cyan-400 hover:underline text-sm">
                    View
                </a>
            </div>
            <div class="p-4 bg-blue-50 dark:bg-blue-900/20 border border-blue-200 dark:border-blue-800 rounded-lg">
                <p class="text-sm text-blue-800 dark:text-blue-200">
                    <strong>Tip:</strong> Submit your sitemap to Google Search Console and Bing Webmaster Tools for better indexing.
                </p>
            </div>
        </div>
    </div>
    
    {{-- SEO Checklist --}}
    <div class="lg:col-span-2 bg-white dark:bg-gray-800 rounded-lg shadow-sm border border-gray-200 dark:border-gray-700 p-6">
        <h2 class="text-xl font-semibold text-gray-900 dark:text-white mb-4">SEO Best Practices Checklist</h2>
        <div class="grid grid-cols-1 md:grid-cols-2 gap-4">
            <div class="flex items-start space-x-3">
                <svg class="w-5 h-5 text-green-500 mt-0.5" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                    <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M9 12l2 2 4-4m6 2a9 9 0 11-18 0 9 9 0 0118 0z" />
                </svg>
                <div>
                    <p class="text-sm font-medium text-gray-900 dark:text-white">Meta Tags</p>
                    <p class="text-xs text-gray-500 dark:text-gray-400">All pages have proper meta titles and descriptions</p>
                </div>
            </div>
            <div class="flex items-start space-x-3">
                <svg class="w-5 h-5 text-green-500 mt-0.5" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                    <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M9 12l2 2 4-4m6 2a9 9 0 11-18 0 9 9 0 0118 0z" />
                </svg>
                <div>
                    <p class="text-sm font-medium text-gray-900 dark:text-white">Open Graph Tags</p>
                    <p class="text-xs text-gray-500 dark:text-gray-400">Social media sharing optimized</p>
                </div>
            </div>
            <div class="flex items-start space-x-3">
                <svg class="w-5 h-5 text-green-500 mt-0.5" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                    <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M9 12l2 2 4-4m6 2a9 9 0 11-18 0 9 9 0 0118 0z" />
                </svg>
                <div>
                    <p class="text-sm font-medium text-gray-900 dark:text-white">Sitemap</p>
                    <p class="text-xs text-gray-500 dark:text-gray-400">XML sitemap generated and accessible</p>
                </div>
            </div>
            <div class="flex items-start space-x-3">
                <svg class="w-5 h-5 text-green-500 mt-0.5" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                    <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M9 12l2 2 4-4m6 2a9 9 0 11-18 0 9 9 0 0118 0z" />
                </svg>
                <div>
                    <p class="text-sm font-medium text-gray-900 dark:text-white">URL Structure</p>
                    <p class="text-xs text-gray-500 dark:text-gray-400">SEO-friendly URLs with slugs</p>
                </div>
            </div>
        </div>
    </div>
</div>
@endsection

