@extends('layouts.admin')

@section('title', $product->name . ' - Admin')

@section('content')
<div class="mb-8">
    <h1 class="text-4xl font-bold font-heading text-white">{{ $product->name }}</h1>
    <a href="{{ route('admin.products.index') }}" class="text-[#00B4D8] hover:text-[#00B4D8]/80 mt-2 inline-block">
        ← Back to Products
    </a>
</div>

<div class="bg-[#1a1a1a] border border-gray-800 rounded-lg p-8 space-y-6">
    <div class="flex space-x-4">
        <a href="{{ route('admin.products.edit', $product) }}" 
           class="px-6 py-3 bg-[#00B4D8] text-white font-semibold rounded-lg hover:bg-[#00B4D8]/80 transition-colors">
            Edit
        </a>
        <form action="{{ route('admin.products.destroy', $product) }}" method="POST" class="inline"
              onsubmit="return confirm('Are you sure you want to delete this product?');">
            @csrf
            @method('DELETE')
            <button type="submit" 
                    class="px-6 py-3 bg-red-600 text-white font-semibold rounded-lg hover:bg-red-700 transition-colors">
                Delete
            </button>
        </form>
    </div>

    @if($product->featured_image)
        <div>
            <img src="{{ Storage::url($product->featured_image) }}" alt="{{ $product->name }}" class="w-full max-w-2xl rounded-lg">
        </div>
    @endif

    <div>
        <h3 class="text-lg font-semibold text-[#E0E0E0] mb-2">Description</h3>
        <div class="text-[#E0E0E0]/70 whitespace-pre-wrap">{{ $product->description ?? 'No description' }}</div>
    </div>
</div>
@endsection

