@extends('layouts.admin')

@section('title', 'Products - Admin')

@section('content')
<div class="flex justify-between items-center mb-8">
    <h1 class="text-4xl font-bold font-heading text-white">Products</h1>
    <a href="{{ route('admin.products.create') }}" 
       class="px-6 py-3 bg-[#00B4D8] text-white font-semibold rounded-lg hover:bg-[#00B4D8]/80 transition-colors">
        Create New Product
    </a>
</div>

<div class="bg-[#1a1a1a] border border-gray-800 rounded-lg overflow-hidden">
    <table class="w-full">
        <thead class="bg-gray-900">
            <tr>
                <th class="px-6 py-4 text-left text-sm font-semibold text-[#E0E0E0]">Name</th>
                <th class="px-6 py-4 text-left text-sm font-semibold text-[#E0E0E0]">Price</th>
                <th class="px-6 py-4 text-left text-sm font-semibold text-[#E0E0E0]">Status</th>
                <th class="px-6 py-4 text-left text-sm font-semibold text-[#E0E0E0]">Created</th>
                <th class="px-6 py-4 text-right text-sm font-semibold text-[#E0E0E0]">Actions</th>
            </tr>
        </thead>
        <tbody class="divide-y divide-gray-800">
            @forelse($products as $product)
                <tr class="hover:bg-gray-800/50 transition-colors">
                    <td class="px-6 py-4">
                        <a href="{{ route('admin.products.show', $product) }}" class="text-[#E0E0E0] hover:text-[#00B4D8] transition-colors">
                            {{ $product->name }}
                        </a>
                    </td>
                    <td class="px-6 py-4 text-[#E0E0E0]/70">{{ $product->formatted_price }}</td>
                    <td class="px-6 py-4">
                        @if($product->status === 'active')
                            <span class="px-3 py-1 text-xs font-semibold bg-green-500/20 text-green-400 rounded-full">Active</span>
                        @else
                            <span class="px-3 py-1 text-xs font-semibold bg-yellow-500/20 text-yellow-400 rounded-full">Inactive</span>
                        @endif
                    </td>
                    <td class="px-6 py-4 text-[#E0E0E0]/70 text-sm">{{ $product->created_at->format('M d, Y') }}</td>
                    <td class="px-6 py-4 text-right">
                        <div class="flex justify-end space-x-2">
                            <a href="{{ route('admin.products.edit', $product) }}" 
                               class="px-3 py-1 text-sm bg-gray-700 text-[#E0E0E0] rounded hover:bg-gray-600 transition-colors">
                                Edit
                            </a>
                            <form action="{{ route('admin.products.destroy', $product) }}" method="POST" class="inline"
                                  onsubmit="return confirm('Are you sure you want to delete this product?');">
                                @csrf
                                @method('DELETE')
                                <button type="submit" 
                                        class="px-3 py-1 text-sm bg-red-600 text-white rounded hover:bg-red-700 transition-colors">
                                    Delete
                                </button>
                            </form>
                        </div>
                    </td>
                </tr>
            @empty
                <tr>
                    <td colspan="5" class="px-6 py-12 text-center text-[#E0E0E0]/50">
                        No products found. <a href="{{ route('admin.products.create') }}" class="text-[#00B4D8] hover:underline">Create one</a>
                    </td>
                </tr>
            @endforelse
        </tbody>
    </table>
</div>

<div class="mt-6">
    {{ $products->links() }}
</div>
@endsection

