@extends('layouts.admin')

@section('title', 'Edit Product - Admin')

@section('content')
<div class="mb-8">
    <h1 class="text-4xl font-bold font-heading text-white">Edit Product</h1>
    <a href="{{ route('admin.products.index') }}" class="text-[#00B4D8] hover:text-[#00B4D8]/80 mt-2 inline-block">
        ← Back to Products
    </a>
</div>

<form action="{{ route('admin.products.update', $product) }}" method="POST" enctype="multipart/form-data" class="bg-[#1a1a1a] border border-gray-800 rounded-lg p-8">
    @csrf
    @method('PUT')

    <div class="space-y-6">
        <div>
            <label for="name" class="block text-[#E0E0E0] font-semibold mb-2">Name *</label>
            <input type="text" id="name" name="name" value="{{ old('name', $product->name) }}" required
                   class="w-full px-4 py-3 bg-[#121212] border border-gray-700 rounded-lg text-[#E0E0E0] focus:outline-none focus:border-[#00B4D8]">
            @error('name')<p class="mt-2 text-sm text-red-500">{{ $message }}</p>@enderror
        </div>

        <div>
            <label for="slug" class="block text-[#E0E0E0] font-semibold mb-2">Slug</label>
            <input type="text" id="slug" name="slug" value="{{ old('slug', $product->slug) }}"
                   class="w-full px-4 py-3 bg-[#121212] border border-gray-700 rounded-lg text-[#E0E0E0] focus:outline-none focus:border-[#00B4D8]">
            @error('slug')<p class="mt-2 text-sm text-red-500">{{ $message }}</p>@enderror
        </div>

        <div>
            <label for="short_description" class="block text-[#E0E0E0] font-semibold mb-2">Short Description</label>
            <textarea id="short_description" name="short_description" rows="3"
                      class="w-full px-4 py-3 bg-[#121212] border border-gray-700 rounded-lg text-[#E0E0E0] focus:outline-none focus:border-[#00B4D8] resize-none">{{ old('short_description', $product->short_description) }}</textarea>
            @error('short_description')<p class="mt-2 text-sm text-red-500">{{ $message }}</p>@enderror
        </div>

        <div>
            <label for="description" class="block text-[#E0E0E0] font-semibold mb-2">Description</label>
            <textarea id="description" name="description" rows="8"
                      class="w-full px-4 py-3 bg-[#121212] border border-gray-700 rounded-lg text-[#E0E0E0] focus:outline-none focus:border-[#00B4D8] resize-none">{{ old('description', $product->description) }}</textarea>
            @error('description')<p class="mt-2 text-sm text-red-500">{{ $message }}</p>@enderror
        </div>

        <div>
            <label for="price" class="block text-[#E0E0E0] font-semibold mb-2">Price</label>
            <input type="number" id="price" name="price" value="{{ old('price', $product->price) }}" step="0.01" min="0"
                   class="w-full px-4 py-3 bg-[#121212] border border-gray-700 rounded-lg text-[#E0E0E0] focus:outline-none focus:border-[#00B4D8]">
            @error('price')<p class="mt-2 text-sm text-red-500">{{ $message }}</p>@enderror
        </div>

        <div>
            <label for="featured_image" class="block text-[#E0E0E0] font-semibold mb-2">Featured Image</label>
            @if($product->featured_image)
                <div class="mb-4">
                    <img src="{{ Storage::url($product->featured_image) }}" alt="Current image" class="w-32 h-32 object-cover rounded-lg">
                </div>
            @endif
            <input type="file" id="featured_image" name="featured_image" accept="image/*"
                   class="w-full px-4 py-3 bg-[#121212] border border-gray-700 rounded-lg text-[#E0E0E0] focus:outline-none focus:border-[#00B4D8]">
            @error('featured_image')<p class="mt-2 text-sm text-red-500">{{ $message }}</p>@enderror
        </div>

        <div>
            <label for="images" class="block text-[#E0E0E0] font-semibold mb-2">Additional Images (multiple)</label>
            @if($product->images && count($product->images) > 0)
                <div class="mb-4 grid grid-cols-4 gap-4">
                    @foreach($product->images as $image)
                        <img src="{{ Storage::url($image) }}" alt="Product image" class="w-full h-24 object-cover rounded-lg">
                    @endforeach
                </div>
            @endif
            <input type="file" id="images" name="images[]" accept="image/*" multiple
                   class="w-full px-4 py-3 bg-[#121212] border border-gray-700 rounded-lg text-[#E0E0E0] focus:outline-none focus:border-[#00B4D8]">
            @error('images')<p class="mt-2 text-sm text-red-500">{{ $message }}</p>@enderror
        </div>

        <div>
            <label for="themeforest_url" class="block text-[#E0E0E0] font-semibold mb-2">ThemeForest URL</label>
            <input type="url" id="themeforest_url" name="themeforest_url" value="{{ old('themeforest_url', $product->themeforest_url) }}"
                   class="w-full px-4 py-3 bg-[#121212] border border-gray-700 rounded-lg text-[#E0E0E0] focus:outline-none focus:border-[#00B4D8]">
            @error('themeforest_url')<p class="mt-2 text-sm text-red-500">{{ $message }}</p>@enderror
        </div>

        <div>
            <label for="status" class="block text-[#E0E0E0] font-semibold mb-2">Status *</label>
            <select id="status" name="status" required
                    class="w-full px-4 py-3 bg-[#121212] border border-gray-700 rounded-lg text-[#E0E0E0] focus:outline-none focus:border-[#00B4D8]">
                <option value="active" {{ old('status', $product->status) === 'active' ? 'selected' : '' }}>Active</option>
                <option value="inactive" {{ old('status', $product->status) === 'inactive' ? 'selected' : '' }}>Inactive</option>
            </select>
            @error('status')<p class="mt-2 text-sm text-red-500">{{ $message }}</p>@enderror
        </div>

        <div class="flex space-x-4">
            <button type="submit" 
                    class="px-8 py-3 bg-[#00B4D8] text-white font-semibold rounded-lg hover:bg-[#00B4D8]/80 transition-colors">
                Update Product
            </button>
            <a href="{{ route('admin.products.index') }}" 
               class="px-8 py-3 bg-gray-700 text-[#E0E0E0] font-semibold rounded-lg hover:bg-gray-600 transition-colors">
                Cancel
            </a>
        </div>
    </div>
</form>
@endsection

