@extends('admin.layouts.app')

@section('title', 'Error Logs')

@section('page-header')
<div class="flex items-center justify-between">
    <div>
        <h1 class="text-3xl font-bold text-gray-900 dark:text-white">Error Logs</h1>
        <p class="mt-1 text-sm text-gray-500 dark:text-gray-400">View and track system errors</p>
    </div>
    <a href="{{ route('admin.logs.index') }}" 
       class="inline-flex items-center px-4 py-2 bg-gray-600 hover:bg-gray-700 text-white font-medium rounded-lg transition-colors">
        ← Back to Logs
    </a>
</div>
@endsection

@section('content')
<div class="bg-white dark:bg-gray-800 rounded-lg shadow-sm border border-gray-200 dark:border-gray-700 p-6">
    <div class="space-y-2 max-h-96 overflow-y-auto">
        @php
            $logFile = storage_path('logs/laravel.log');
            $logs = file_exists($logFile) ? file($logFile) : [];
            $errorLogs = array_filter($logs, fn($log) => stripos($log, 'error') !== false || stripos($log, 'exception') !== false);
        @endphp
        @forelse(array_slice(array_reverse($errorLogs), 0, 50) as $log)
            <div class="p-3 bg-red-50 dark:bg-red-900/20 border border-red-200 dark:border-red-800 rounded text-xs font-mono text-red-800 dark:text-red-200">
                {{ Str::limit($log, 300) }}
            </div>
        @empty
            <p class="text-gray-500 dark:text-gray-400 text-center py-8">No errors found. Great!</p>
        @endforelse
    </div>
</div>
@endsection

