@extends('admin.layouts.app')

@section('title', 'Preview Imported Content')

@section('content')
{{-- Preview Page: Display parsed content with edit capability before saving --}}
<div class="max-w-7xl mx-auto">
    {{-- Page Header --}}
    <div class="mb-8">
        <h1 class="text-3xl font-heading font-bold text-gray-900 dark:text-white mb-2">
            Preview Imported Content
        </h1>
        <p class="text-gray-600 dark:text-gray-400">
            Review and edit the parsed content before saving as a Post or Product.
        </p>
    </div>

    <form action="{{ route('admin.import.store') }}" method="POST" class="space-y-6">
        @csrf

        {{-- Target Type Selection --}}
        <div class="bg-white dark:bg-gray-800 rounded-lg shadow-lg p-6">
            <label class="block text-sm font-semibold text-gray-700 dark:text-gray-300 mb-3">
                Save As
            </label>
            <div class="flex space-x-4">
                <label class="flex items-center p-3 border-2 border-gray-300 dark:border-gray-600 rounded-lg cursor-pointer hover:border-cyan-500 transition-colors">
                    <input type="radio" name="target_type" value="post" checked class="mr-2 text-cyan-500 focus:ring-cyan-500">
                    <span class="text-sm text-gray-700 dark:text-gray-300">Blog Post</span>
                </label>
                <label class="flex items-center p-3 border-2 border-gray-300 dark:border-gray-600 rounded-lg cursor-pointer hover:border-cyan-500 transition-colors">
                    <input type="radio" name="target_type" value="product" class="mr-2 text-cyan-500 focus:ring-cyan-500">
                    <span class="text-sm text-gray-700 dark:text-gray-300">Product</span>
                </label>
            </div>
        </div>

        {{-- Basic Information --}}
        <div class="bg-white dark:bg-gray-800 rounded-lg shadow-lg p-6 lg:p-8 space-y-6">
            <h2 class="text-xl font-heading font-semibold text-gray-900 dark:text-white border-b border-gray-200 dark:border-gray-700 pb-3">
                Basic Information
            </h2>

            {{-- Title --}}
            <div>
                <label for="title" class="block text-sm font-semibold text-gray-700 dark:text-gray-300 mb-2">
                    Title *
                </label>
                <input 
                    type="text" 
                    id="title" 
                    name="title" 
                    value="{{ old('title', $parsed['title'] ?? '') }}"
                    required
                    class="w-full px-4 py-2.5 bg-gray-50 dark:bg-gray-700 border border-gray-300 dark:border-gray-600 rounded-lg text-gray-900 dark:text-gray-100 focus:outline-none focus:ring-2 focus:ring-cyan-500 focus:border-transparent">
            </div>

            {{-- Slug --}}
            <div>
                <label for="slug" class="block text-sm font-semibold text-gray-700 dark:text-gray-300 mb-2">
                    Slug
                </label>
                <input 
                    type="text" 
                    id="slug" 
                    name="slug" 
                    value="{{ old('slug', $parsed['slug'] ?? '') }}"
                    class="w-full px-4 py-2.5 bg-gray-50 dark:bg-gray-700 border border-gray-300 dark:border-gray-600 rounded-lg text-gray-900 dark:text-gray-100 focus:outline-none focus:ring-2 focus:ring-cyan-500 focus:border-transparent">
            </div>

            {{-- Summary --}}
            <div>
                <label for="summary" class="block text-sm font-semibold text-gray-700 dark:text-gray-300 mb-2">
                    Summary / Excerpt
                </label>
                <textarea 
                    id="summary" 
                    name="summary" 
                    rows="3"
                    class="w-full px-4 py-2.5 bg-gray-50 dark:bg-gray-700 border border-gray-300 dark:border-gray-600 rounded-lg text-gray-900 dark:text-gray-100 focus:outline-none focus:ring-2 focus:ring-cyan-500 focus:border-transparent resize-y">{{ old('summary', $parsed['summary'] ?? '') }}</textarea>
            </div>
        </div>

        {{-- Content --}}
        <div class="bg-white dark:bg-gray-800 rounded-lg shadow-lg p-6 lg:p-8">
            <h2 class="text-xl font-heading font-semibold text-gray-900 dark:text-white border-b border-gray-200 dark:border-gray-700 pb-3 mb-4">
                Content
            </h2>
            <textarea 
                id="content_html" 
                name="content_html" 
                rows="10"
                class="w-full px-4 py-2.5 bg-gray-50 dark:bg-gray-700 border border-gray-300 dark:border-gray-600 rounded-lg text-gray-900 dark:text-gray-100 font-mono text-sm focus:outline-none focus:ring-2 focus:ring-cyan-500 focus:border-transparent resize-y">{{ old('content_html', $parsed['content_html'] ?? '') }}</textarea>
        </div>

        {{-- Pros & Cons --}}
        <div class="grid md:grid-cols-2 gap-6">
            {{-- Pros --}}
            <div class="bg-white dark:bg-gray-800 rounded-lg shadow-lg p-6">
                <h2 class="text-xl font-heading font-semibold text-gray-900 dark:text-white border-b border-gray-200 dark:border-gray-700 pb-3 mb-4">
                    Pros
                </h2>
                <div id="prosContainer" class="space-y-2">
                    @if(!empty($parsed['pros']))
                        @foreach($parsed['pros'] as $index => $pro)
                            <div class="flex items-center space-x-2">
                                <input 
                                    type="text" 
                                    name="pros[]" 
                                    value="{{ is_array($pro) ? (isset($pro['name']) ? $pro['name'] : (isset($pro['title']) ? $pro['title'] : (isset($pro[0]) ? $pro[0] : ''))) : (string)$pro }}"
                                    class="flex-1 px-3 py-2 bg-gray-50 dark:bg-gray-700 border border-gray-300 dark:border-gray-600 rounded-lg text-gray-900 dark:text-gray-100 text-sm focus:outline-none focus:ring-2 focus:ring-cyan-500">
                                <button type="button" onclick="removeItem(this)" class="text-red-500 hover:text-red-700">
                                    <svg class="w-5 h-5" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                                        <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M6 18L18 6M6 6l12 12" />
                                    </svg>
                                </button>
                            </div>
                        @endforeach
                    @endif
                </div>
                <button type="button" onclick="addItem('prosContainer', 'pros')" class="mt-3 text-sm text-cyan-500 hover:text-cyan-600">
                    + Add Pro
                </button>
            </div>

            {{-- Cons --}}
            <div class="bg-white dark:bg-gray-800 rounded-lg shadow-lg p-6">
                <h2 class="text-xl font-heading font-semibold text-gray-900 dark:text-white border-b border-gray-200 dark:border-gray-700 pb-3 mb-4">
                    Cons
                </h2>
                <div id="consContainer" class="space-y-2">
                    @if(!empty($parsed['cons']))
                        @foreach($parsed['cons'] as $index => $con)
                            <div class="flex items-center space-x-2">
                                <input 
                                    type="text" 
                                    name="cons[]" 
                                    value="{{ is_array($con) ? (isset($con['name']) ? $con['name'] : (isset($con['title']) ? $con['title'] : (isset($con[0]) ? $con[0] : ''))) : (string)$con }}"
                                    class="flex-1 px-3 py-2 bg-gray-50 dark:bg-gray-700 border border-gray-300 dark:border-gray-600 rounded-lg text-gray-900 dark:text-gray-100 text-sm focus:outline-none focus:ring-2 focus:ring-cyan-500">
                                <button type="button" onclick="removeItem(this)" class="text-red-500 hover:text-red-700">
                                    <svg class="w-5 h-5" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                                        <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M6 18L18 6M6 6l12 12" />
                                    </svg>
                                </button>
                            </div>
                        @endforeach
                    @endif
                </div>
                <button type="button" onclick="addItem('consContainer', 'cons')" class="mt-3 text-sm text-cyan-500 hover:text-cyan-600">
                    + Add Con
                </button>
            </div>
        </div>

        {{-- Features --}}
        <div class="bg-white dark:bg-gray-800 rounded-lg shadow-lg p-6 lg:p-8">
            <h2 class="text-xl font-heading font-semibold text-gray-900 dark:text-white border-b border-gray-200 dark:border-gray-700 pb-3 mb-4">
                Features
            </h2>
            <div id="featuresContainer" class="space-y-2">
                @if(!empty($parsed['features']))
                    @foreach($parsed['features'] as $index => $feature)
                        <div class="flex items-center space-x-2">
                            <input 
                                type="text" 
                                name="features[]" 
                                value="{{ is_array($feature) ? (isset($feature['name']) ? $feature['name'] : (isset($feature['title']) ? $feature['title'] : (isset($feature[0]) ? $feature[0] : json_encode($feature)))) : (string)$feature }}"
                                class="flex-1 px-3 py-2 bg-gray-50 dark:bg-gray-700 border border-gray-300 dark:border-gray-600 rounded-lg text-gray-900 dark:text-gray-100 text-sm focus:outline-none focus:ring-2 focus:ring-cyan-500">
                            <button type="button" onclick="removeItem(this)" class="text-red-500 hover:text-red-700">
                                <svg class="w-5 h-5" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                                    <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M6 18L18 6M6 6l12 12" />
                                </svg>
                            </button>
                        </div>
                    @endforeach
                @endif
            </div>
            <button type="button" onclick="addItem('featuresContainer', 'features')" class="mt-3 text-sm text-cyan-500 hover:text-cyan-600">
                + Add Feature
            </button>
        </div>

        {{-- FAQs --}}
        @if(!empty($parsed['faqs']))
        <div class="bg-white dark:bg-gray-800 rounded-lg shadow-lg p-6 lg:p-8">
            <h2 class="text-xl font-heading font-semibold text-gray-900 dark:text-white border-b border-gray-200 dark:border-gray-700 pb-3 mb-4">
                FAQs
            </h2>
            <div id="faqsContainer" class="space-y-4">
                @foreach($parsed['faqs'] as $index => $faq)
                    <div class="border border-gray-200 dark:border-gray-700 rounded-lg p-4">
                        <input 
                            type="text" 
                            name="faqs[{{ $index }}][question]" 
                            value="{{ is_array($faq) ? ($faq['question'] ?? '') : '' }}"
                            placeholder="Question"
                            class="w-full px-3 py-2 bg-gray-50 dark:bg-gray-700 border border-gray-300 dark:border-gray-600 rounded-lg text-gray-900 dark:text-gray-100 text-sm mb-2 focus:outline-none focus:ring-2 focus:ring-cyan-500">
                        <textarea 
                            name="faqs[{{ $index }}][answer]" 
                            rows="2"
                            placeholder="Answer"
                            class="w-full px-3 py-2 bg-gray-50 dark:bg-gray-700 border border-gray-300 dark:border-gray-600 rounded-lg text-gray-900 dark:text-gray-100 text-sm focus:outline-none focus:ring-2 focus:ring-cyan-500">{{ is_array($faq) ? ($faq['answer'] ?? '') : '' }}</textarea>
                    </div>
                @endforeach
            </div>
        </div>
        @endif

        {{-- SEO & Additional --}}
        <div class="bg-white dark:bg-gray-800 rounded-lg shadow-lg p-6 lg:p-8 space-y-6">
            <h2 class="text-xl font-heading font-semibold text-gray-900 dark:text-white border-b border-gray-200 dark:border-gray-700 pb-3">
                SEO & Additional Information
            </h2>

            <div class="grid md:grid-cols-2 gap-6">
                <div>
                    <label for="meta_title" class="block text-sm font-semibold text-gray-700 dark:text-gray-300 mb-2">
                        Meta Title
                    </label>
                    <input 
                        type="text" 
                        id="meta_title" 
                        name="meta_title" 
                        value="{{ old('meta_title', $parsed['seo']['meta_title'] ?? '') }}"
                        class="w-full px-4 py-2.5 bg-gray-50 dark:bg-gray-700 border border-gray-300 dark:border-gray-600 rounded-lg text-gray-900 dark:text-gray-100 focus:outline-none focus:ring-2 focus:ring-cyan-500">
                </div>

                <div>
                    <label for="affiliate_link" class="block text-sm font-semibold text-gray-700 dark:text-gray-300 mb-2">
                        Affiliate Link
                    </label>
                    <input 
                        type="url" 
                        id="affiliate_link" 
                        name="affiliate_link" 
                        value="{{ old('affiliate_link', $parsed['affiliate_link'] ?? '') }}"
                        class="w-full px-4 py-2.5 bg-gray-50 dark:bg-gray-700 border border-gray-300 dark:border-gray-600 rounded-lg text-gray-900 dark:text-gray-100 focus:outline-none focus:ring-2 focus:ring-cyan-500">
                </div>
            </div>

            <div>
                <label for="cta_section" class="block text-sm font-semibold text-gray-700 dark:text-gray-300 mb-2">
                    Call to Action (CTA) Text
                </label>
                <input 
                    type="text" 
                    id="cta_section" 
                    name="cta_section" 
                    value="{{ old('cta_section', $parsed['cta_section'] ?? $parsed['cta'] ?? '') }}"
                    class="w-full px-4 py-2.5 bg-gray-50 dark:bg-gray-700 border border-gray-300 dark:border-gray-600 rounded-lg text-gray-900 dark:text-gray-100 focus:outline-none focus:ring-2 focus:ring-cyan-500"
                    placeholder="e.g., Ready to get started?">
                <p class="mt-1 text-xs text-gray-500 dark:text-gray-400">This text will appear above the affiliate link button</p>
            </div>

            <div>
                <label for="meta_description" class="block text-sm font-semibold text-gray-700 dark:text-gray-300 mb-2">
                    Meta Description
                </label>
                <textarea 
                    id="meta_description" 
                    name="meta_description" 
                    rows="3"
                    class="w-full px-4 py-2.5 bg-gray-50 dark:bg-gray-700 border border-gray-300 dark:border-gray-600 rounded-lg text-gray-900 dark:text-gray-100 focus:outline-none focus:ring-2 focus:ring-cyan-500 resize-y">{{ old('meta_description', $parsed['seo']['meta_description'] ?? '') }}</textarea>
            </div>

            <div class="grid md:grid-cols-3 gap-6">
                <div>
                    <label for="category" class="block text-sm font-semibold text-gray-700 dark:text-gray-300 mb-2">
                        Category
                    </label>
                    <input 
                        type="text" 
                        id="category" 
                        name="category" 
                        value="{{ old('category', '') }}"
                        class="w-full px-4 py-2.5 bg-gray-50 dark:bg-gray-700 border border-gray-300 dark:border-gray-600 rounded-lg text-gray-900 dark:text-gray-100 focus:outline-none focus:ring-2 focus:ring-cyan-500"
                        placeholder="e.g., Review, Tutorial">
                </div>

                <div>
                    <label for="price" class="block text-sm font-semibold text-gray-700 dark:text-gray-300 mb-2">
                        Price (for products)
                    </label>
                    <input 
                        type="number" 
                        id="price" 
                        name="price" 
                        step="0.01"
                        value="{{ old('price', 0) }}"
                        class="w-full px-4 py-2.5 bg-gray-50 dark:bg-gray-700 border border-gray-300 dark:border-gray-600 rounded-lg text-gray-900 dark:text-gray-100 focus:outline-none focus:ring-2 focus:ring-cyan-500">
                </div>

                <div>
                    <label for="status" class="block text-sm font-semibold text-gray-700 dark:text-gray-300 mb-2">
                        Status
                    </label>
                    <select 
                        id="status" 
                        name="status"
                        class="w-full px-4 py-2.5 bg-gray-50 dark:bg-gray-700 border border-gray-300 dark:border-gray-600 rounded-lg text-gray-900 dark:text-gray-100 focus:outline-none focus:ring-2 focus:ring-cyan-500">
                        <option value="draft">Draft</option>
                        <option value="published">Published</option>
                        <option value="active">Active</option>
                    </select>
                </div>
            </div>
        </div>

        {{-- Action Buttons --}}
        <div class="flex items-center justify-between">
            <a href="{{ route('admin.import.index') }}" class="px-6 py-2.5 bg-gray-200 dark:bg-gray-700 text-gray-700 dark:text-gray-300 rounded-lg hover:bg-gray-300 dark:hover:bg-gray-600 transition-colors font-medium">
                Back to Import
            </a>
            <button 
                type="submit" 
                class="px-6 py-2.5 bg-cyan-500 hover:bg-cyan-600 text-white rounded-lg transition-colors font-medium">
                Save Content
            </button>
        </div>
    </form>
</div>

@push('scripts')
<script>
    function addItem(containerId, name) {
        const container = document.getElementById(containerId);
        const div = document.createElement('div');
        div.className = 'flex items-center space-x-2';
        div.innerHTML = `
            <input 
                type="text" 
                name="${name}[]" 
                class="flex-1 px-3 py-2 bg-gray-50 dark:bg-gray-700 border border-gray-300 dark:border-gray-600 rounded-lg text-gray-900 dark:text-gray-100 text-sm focus:outline-none focus:ring-2 focus:ring-cyan-500">
            <button type="button" onclick="removeItem(this)" class="text-red-500 hover:text-red-700">
                <svg class="w-5 h-5" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                    <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M6 18L18 6M6 6l12 12" />
                </svg>
            </button>
        `;
        container.appendChild(div);
    }
    
    function removeItem(button) {
        button.closest('div').remove();
    }
</script>
@endpush
@endsection

