<?php

namespace Database\Seeders;

use App\Models\User;
use App\Models\Role;
use Illuminate\Database\Seeder;

class AssignAdminRoleSeeder extends Seeder
{
    /**
     * Run the database seeds.
     */
    public function run(): void
    {
        $admin = User::where('email', 'admin@linkie.dev')->first();
        $adminRole = Role::where('slug', 'admin')->first();
        
        if ($admin && $adminRole) {
            $admin->roles()->syncWithoutDetaching([$adminRole->id]);
            $this->command->info('Admin role assigned to admin@linkie.dev');
        } else {
            $this->command->warn('Admin user or role not found');
        }
    }
}
