<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Model;
use Illuminate\Support\Str;

class Role extends Model
{
    protected $fillable = [
        'name',
        'slug',
        'description',
        'permissions',
    ];

    protected function casts(): array
    {
        return [
            'permissions' => 'array',
        ];
    }

    /**
     * Get users with this role.
     */
    public function users()
    {
        return $this->belongsToMany(User::class);
    }

    /**
     * Generate slug from name if not provided.
     */
    public function setSlugAttribute($value)
    {
        if (empty($value) && isset($this->attributes['name'])) {
            $this->attributes['slug'] = Str::slug($this->attributes['name']);
        } elseif (!empty($value)) {
            $this->attributes['slug'] = Str::slug($value);
        }
    }
}
