<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Model;
use Illuminate\Support\Str;

class Product extends Model
{
    protected $fillable = [
        'name',
        'slug',
        'description',
        'short_description',
        'price',
        'featured_image',
        'images',
        'themeforest_url',
        'status',
        'featured',
    ];

    protected function casts(): array
    {
        return [
            'images' => 'array',
            'price' => 'decimal:2',
            'featured' => 'boolean',
        ];
    }

    /**
     * Generate slug from name if not provided
     */
    public function setSlugAttribute($value)
    {
        if (empty($value) && isset($this->attributes['name'])) {
            $this->attributes['slug'] = Str::slug($this->attributes['name']);
        } elseif (!empty($value)) {
            $this->attributes['slug'] = Str::slug($value);
        }
    }

    /**
     * Get active products
     */
    public function scopeActive($query)
    {
        return $query->where('status', 'active');
    }

    /**
     * Get formatted price
     */
    public function getFormattedPriceAttribute()
    {
        return $this->price ? '$' . number_format($this->price, 2) : 'Free';
    }
}
