<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Model;

class NavigationMenu extends Model
{
    protected $fillable = [
        'label',
        'url',
        'route',
        'icon',
        'parent_id',
        'order',
        'target',
        'active',
    ];

    protected function casts(): array
    {
        return [
            'order' => 'integer',
            'active' => 'boolean',
        ];
    }

    /**
     * Get parent menu item.
     */
    public function parent()
    {
        return $this->belongsTo(NavigationMenu::class, 'parent_id');
    }

    /**
     * Get child menu items.
     */
    public function children()
    {
        return $this->hasMany(NavigationMenu::class, 'parent_id')->orderBy('order');
    }
}

