<?php

namespace App\Http\Controllers;

use App\Models\Post;
use App\Models\Product;
use Illuminate\Http\Request;

class HomeController extends Controller
{
    public function index()
    {
        // Get latest published blog posts (limit 6)
        $latestPosts = Post::published()
            ->latest('published_at')
            ->limit(6)
            ->get();

        // Get featured products (active, limit 6)
        $featuredProducts = Product::active()
            ->latest()
            ->limit(6)
            ->get();

        return view('home', compact('latestPosts', 'featuredProducts'));
    }
}
